/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.block.alchemist_cauldron;

import java.util.function.Predicate;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;

public class CauldronPlatformHelper {
    public static final Predicate<ItemStack> IS_WATER = itemStack -> itemStack.has(DataComponents.POTION_CONTENTS) && ((PotionContents)itemStack.get(DataComponents.POTION_CONTENTS)).is(Potions.WATER);

    public static boolean itemMatches(ItemStack a, ItemStack b) {
        return ItemStack.isSameItemSameComponents((ItemStack)a, (ItemStack)b);
    }

    public static boolean isBrewingIngredient(ItemStack stack, Level level) {
        return level.potionBrewing().isIngredient(stack);
    }

    public static ItemStack getNonDestructiveBrewingResult(ItemStack base, ItemStack reagent, Level level) {
        return level.potionBrewing().hasPotionMix(base, reagent) || level.potionBrewing().hasContainerMix(base, reagent) ? level.potionBrewing().mix(reagent, base) : ItemStack.EMPTY;
    }
}

