/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.block.alchemist_cauldron;

import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronBlock;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronBuildInteractionsEvent;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronInteraction;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronRecipe;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronRecipeRegistry;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.CauldronPlatformHelper;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.item.InkItem;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.item.consumables.SimpleElixir;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public class AlchemistCauldronTile
extends BlockEntity
implements WorldlyContainer {
    public static int MAX_LEVELS = 4;
    public static final Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction> INTERACTIONS = AlchemistCauldronTile.newInteractionMap();
    public final NonNullList<ItemStack> inputItems = NonNullList.withSize((int)MAX_LEVELS, (Object)ItemStack.EMPTY);
    public final NonNullList<ItemStack> outputItems = NonNullList.withSize((int)MAX_LEVELS, (Object)ItemStack.EMPTY);
    private final int[] cooktimes = new int[MAX_LEVELS];

    public AlchemistCauldronTile(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockRegistry.ALCHEMIST_CAULDRON_TILE.get(), pWorldPosition, pBlockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState blockState, AlchemistCauldronTile cauldronTile) {
        for (int i = 0; i < cauldronTile.inputItems.size(); ++i) {
            ItemStack itemStack = (ItemStack)cauldronTile.inputItems.get(i);
            if (itemStack.isEmpty() || !cauldronTile.isBoiling(blockState)) {
                cauldronTile.cooktimes[i] = 0;
            } else {
                int n = i;
                cauldronTile.cooktimes[n] = cauldronTile.cooktimes[n] + 1;
            }
            if (cauldronTile.cooktimes[i] <= 100) continue;
            cauldronTile.tryMeltInput(itemStack);
            cauldronTile.cooktimes[i] = 0;
        }
        RandomSource random = Utils.random;
        if (cauldronTile.isBoiling(blockState)) {
            float waterLevel = Mth.lerp((float)((float)cauldronTile.getLiquidLevel() / (float)MAX_LEVELS), (float)0.25f, (float)0.9f);
            MagicManager.spawnParticles(level, (ParticleOptions)ParticleTypes.BUBBLE_POP, (float)pos.getX() + Mth.randomBetween((RandomSource)random, (float)0.2f, (float)0.8f), (float)pos.getY() + waterLevel, (float)pos.getZ() + Mth.randomBetween((RandomSource)random, (float)0.2f, (float)0.8f), 1, 0.0, 0.0, 0.0, 0.0, false);
        }
    }

    public ItemInteractionResult handleUse(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AlchemistCauldronTile) {
            AlchemistCauldronTile tile = (AlchemistCauldronTile)blockEntity;
            ItemStack cauldronInteractionResult = ((AlchemistCauldronInteraction)INTERACTIONS.get((Object)itemStack.getItem())).interact(tile, blockState, level, pos, itemStack);
            if (cauldronInteractionResult != null) {
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)itemStack, (Player)player, (ItemStack)cauldronInteractionResult));
                this.setChanged();
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (this.isValidInput(itemStack)) {
                if (!level.isClientSide) {
                    for (int i = 0; i < this.inputItems.size(); ++i) {
                        ItemStack stack = (ItemStack)this.inputItems.get(i);
                        if (!stack.isEmpty()) continue;
                        ItemStack input = player.getAbilities().instabuild ? itemStack.copy() : itemStack.split(1);
                        input.setCount(1);
                        this.inputItems.set(i, (Object)input);
                        player.setItemInHand(hand, itemStack);
                        this.setChanged();
                        break;
                    }
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if ((itemStack.isEmpty() || player.isCrouching()) && hand.equals((Object)InteractionHand.MAIN_HAND)) {
                for (ItemStack item : this.inputItems) {
                    if (item.isEmpty()) continue;
                    if (!level.isClientSide) {
                        ItemStack take = item.split(1);
                        if (player.getItemInHand(hand).isEmpty()) {
                            player.setItemInHand(hand, take);
                        } else if (!player.getInventory().add(take)) {
                            player.drop(take, false);
                        }
                        this.setChanged();
                    }
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected boolean isBaseIngredientPresent(ItemStack stack) {
        return this.isBaseIngredientPresent(stack2 -> CauldronPlatformHelper.itemMatches(stack, stack2), 1);
    }

    protected boolean isBaseIngredientPresent(Predicate<ItemStack> baseIngredientPredicate, int minCount) {
        int count = 0;
        for (ItemStack stack : this.outputItems) {
            if (!baseIngredientPredicate.test(stack) || (count += stack.getCount()) < minCount) continue;
            return true;
        }
        return false;
    }

    protected void convertOutput(Predicate<ItemStack> itemToReplace, ItemStack outputItem, int maxCount) {
        int count = 0;
        for (int i = this.outputItems.size() - 1; i >= 0; --i) {
            ItemStack stack = (ItemStack)this.outputItems.get(i);
            if (!itemToReplace.test(stack)) continue;
            this.outputItems.set(i, (Object)outputItem.copy());
            if (++count < maxCount) continue;
            return;
        }
    }

    public boolean addToOutput(ItemStack itemStack) {
        for (int i = 0; i < this.outputItems.size(); ++i) {
            ItemStack stack = (ItemStack)this.outputItems.get(i);
            if (!stack.isEmpty()) continue;
            this.outputItems.set(i, (Object)itemStack);
            return true;
        }
        return false;
    }

    public void tryMeltInput(ItemStack itemStack) {
        ItemStack potentialPotionBase;
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        boolean shouldMelt = false;
        boolean success = true;
        if (itemStack.is((Item)ItemRegistry.SCROLL.get()) && this.isBaseIngredientPresent(CauldronPlatformHelper.IS_WATER, 1)) {
            if ((double)Utils.random.nextFloat() < (Double)ServerConfigs.SCROLL_RECYCLE_CHANCE.get()) {
                ItemStack result = new ItemStack((ItemLike)AlchemistCauldronTile.getInkFromScroll(itemStack));
                this.convertOutput(CauldronPlatformHelper.IS_WATER, result, 1);
            } else {
                success = false;
            }
            shouldMelt = true;
        }
        if (!shouldMelt && this.isBrewable(itemStack)) {
            for (int i = 0; i < this.outputItems.size(); ++i) {
                ItemStack output;
                potentialPotionBase = (ItemStack)this.outputItems.get(i);
                if (potentialPotionBase.isEmpty() || (output = CauldronPlatformHelper.getNonDestructiveBrewingResult(potentialPotionBase, itemStack, this.level)).isEmpty()) continue;
                this.outputItems.set(i, (Object)output.copy());
                shouldMelt = true;
            }
        }
        if (!shouldMelt && AlchemistCauldronRecipeRegistry.isValidIngredient(itemStack)) {
            for (int i = 0; i < this.outputItems.size(); ++i) {
                AlchemistCauldronRecipe recipe;
                potentialPotionBase = ((ItemStack)this.outputItems.get(i)).copy();
                if (potentialPotionBase.isEmpty() || (recipe = AlchemistCauldronRecipeRegistry.getRecipeForInputs(potentialPotionBase, itemStack)) == null || !this.isBaseIngredientPresent(stack -> CauldronPlatformHelper.itemMatches(stack, potentialPotionBase), recipe.getInput().getCount())) continue;
                ItemStack result = recipe.getResult();
                int toConsume = recipe.getInput().getCount();
                this.convertOutput(stack -> CauldronPlatformHelper.itemMatches(stack, potentialPotionBase.copy()), ItemStack.EMPTY, toConsume);
                int c = result.getCount();
                for (int j = 0; j < c; ++j) {
                    this.addToOutput(result.split(1));
                }
                shouldMelt = true;
                break;
            }
        }
        if (shouldMelt) {
            itemStack.shrink(1);
            this.setChanged();
            if (success) {
                this.level.playSound(null, this.getBlockPos(), SoundEvents.BREWING_STAND_BREW, SoundSource.MASTER, 1.0f, 1.0f);
                this.level.markAndNotifyBlock(this.getBlockPos(), this.level.getChunkAt(this.getBlockPos()), this.getBlockState(), this.getBlockState(), 1, 1);
            } else {
                this.level.playSound(null, this.getBlockPos(), SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.MASTER, 1.0f, 1.0f);
            }
            this.collapseContainer(this.outputItems);
        }
    }

    public void collapseContainer(NonNullList<ItemStack> container) {
        block0: for (int i = 0; i < container.size(); ++i) {
            if (!((ItemStack)container.get(i)).isEmpty()) continue;
            for (int j = i + 1; j < container.size(); ++j) {
                ItemStack stack = (ItemStack)container.get(j);
                if (stack.isEmpty()) continue;
                container.set(i, (Object)stack);
                container.set(j, (Object)ItemStack.EMPTY);
                continue block0;
            }
        }
    }

    public boolean isValidInput(ItemStack itemStack) {
        return itemStack.is((Item)ItemRegistry.SCROLL.get()) || this.isBrewable(itemStack) || AlchemistCauldronRecipeRegistry.isValidIngredient(itemStack);
    }

    public boolean isBrewable(ItemStack itemStack) {
        return (Boolean)ServerConfigs.ALLOW_CAULDRON_BREWING.get() != false && this.level != null && CauldronPlatformHelper.isBrewingIngredient(itemStack, this.level);
    }

    public int getItemWaterColor(ItemStack itemStack) {
        if (this.getLevel() == null) {
            return 0;
        }
        Item item = itemStack.getItem();
        if (item instanceof SimpleElixir) {
            SimpleElixir simpleElixir = (SimpleElixir)item;
            return ((MobEffect)simpleElixir.getMobEffect().getEffect().value()).getColor();
        }
        if (itemStack.is((Item)ItemRegistry.INK_COMMON.get())) {
            return 0x222222;
        }
        if (itemStack.is((Item)ItemRegistry.INK_UNCOMMON.get())) {
            return 1196800;
        }
        if (itemStack.is((Item)ItemRegistry.INK_RARE.get())) {
            return 997444;
        }
        if (itemStack.is((Item)ItemRegistry.INK_EPIC.get())) {
            return 10825376;
        }
        if (itemStack.is((Item)ItemRegistry.INK_LEGENDARY.get())) {
            return 16559900;
        }
        if (itemStack.is((Item)ItemRegistry.BLOOD_VIAL.get())) {
            return 5965590;
        }
        PotionContents potion = (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS);
        if (potion != null && !potion.is(Potions.WATER)) {
            return potion.getColor();
        }
        return BiomeColors.getAverageWaterColor((BlockAndTintGetter)this.getLevel(), (BlockPos)this.getBlockPos());
    }

    public int getAverageWaterColor() {
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        int i = 0;
        for (ItemStack itemStack : this.outputItems) {
            if (itemStack.isEmpty()) continue;
            int k = this.getItemWaterColor(itemStack);
            f += (float)(k >> 16 & 0xFF) / 255.0f;
            f1 += (float)(k >> 8 & 0xFF) / 255.0f;
            f2 += (float)(k >> 0 & 0xFF) / 255.0f;
            ++i;
        }
        f = f / (float)i * 255.0f;
        f1 = f1 / (float)i * 255.0f;
        f2 = f2 / (float)i * 255.0f;
        return (int)f << 16 | (int)f1 << 8 | (int)f2;
    }

    public static Item getInkFromScroll(ItemStack scrollStack) {
        Item item = scrollStack.getItem();
        if (item instanceof Scroll) {
            Scroll scroll = (Scroll)item;
            ISpellContainer spellContainer = ISpellContainer.get(scrollStack);
            SpellData spellData = spellContainer.getSpellAtIndex(0);
            SpellRarity rarity = spellData.getSpell().getRarity(spellData.getLevel());
            return InkItem.getInkForRarity(rarity);
        }
        return Items.AIR;
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public boolean stillValid(Player pPlayer) {
        return false;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registryAccess) {
        Utils.loadAllItems(tag, this.inputItems, "Items", registryAccess);
        Utils.loadAllItems(tag, this.outputItems, "Results", registryAccess);
        super.loadAdditional(tag, registryAccess);
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider registryAccess) {
        Utils.saveAllItems(tag, this.inputItems, "Items", registryAccess);
        Utils.saveAllItems(tag, this.outputItems, "Results", registryAccess);
        super.saveAdditional(tag, registryAccess);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        return packet;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.handleUpdateTag(pkt.getTag(), lookupProvider);
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, pRegistries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.inputItems.clear();
        this.outputItems.clear();
        if (tag != null) {
            this.loadAdditional(tag, lookupProvider);
        }
    }

    public void drops() {
        SimpleContainer simpleContainer = new SimpleContainer(this.inputItems.size());
        for (int i = 0; i < this.inputItems.size(); ++i) {
            simpleContainer.setItem(i, (ItemStack)this.inputItems.get(i));
        }
        if (this.level != null) {
            Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)simpleContainer);
        }
    }

    protected static ItemStack waterBottle() {
        ItemStack stack = new ItemStack((ItemLike)Items.POTION);
        stack.set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WATER));
        return stack;
    }

    static Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction> newInteractionMap() {
        Object2ObjectOpenHashMap map = (Object2ObjectOpenHashMap)Util.make((Object)new Object2ObjectOpenHashMap(), o2o -> o2o.defaultReturnValue((tile, blockState, level, pos, itemstack) -> null));
        map.put((Object)Items.WATER_BUCKET, (tile, blockState, level, pos, itemstack) -> {
            if (tile.outputItems.stream().anyMatch(ItemStack::isEmpty)) {
                level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                for (int i = 0; i < tile.outputItems.size(); ++i) {
                    if (!((ItemStack)tile.outputItems.get(i)).isEmpty()) continue;
                    tile.outputItems.set(i, (Object)AlchemistCauldronTile.waterBottle());
                }
                return new ItemStack((ItemLike)Items.BUCKET);
            }
            return null;
        });
        map.put((Object)Items.BUCKET, (tile, blockState, level, pos, itemstack) -> {
            if (tile.outputItems.stream().allMatch(CauldronPlatformHelper.IS_WATER)) {
                tile.outputItems.clear();
                level.playSound(null, pos, SoundEvents.BUCKET_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
                return new ItemStack((ItemLike)Items.WATER_BUCKET);
            }
            return null;
        });
        map.put((Object)Items.GLASS_BOTTLE, (tile, blockState, level, pos, itemstack) -> {
            for (int i = tile.outputItems.size() - 1; i >= 0; --i) {
                ItemStack stack = (ItemStack)tile.outputItems.get(i);
                if (stack.isEmpty()) continue;
                level.playSound(null, pos, CauldronPlatformHelper.IS_WATER.test(stack) ? SoundEvents.BOTTLE_FILL : SoundEvents.BOTTLE_FILL_DRAGONBREATH, SoundSource.BLOCKS, 1.0f, 1.0f);
                return stack.split(1);
            }
            return null;
        });
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, () -> Items.POTION);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INK_COMMON);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INK_UNCOMMON);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INK_RARE);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INK_EPIC);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INK_LEGENDARY);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.BLOOD_VIAL);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.OAKSKIN_ELIXIR);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.GREATER_OAKSKIN_ELIXIR);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.EVASION_ELIXIR);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.GREATER_EVASION_ELIXIR);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.INVISIBILITY_ELIXIR);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.GREATER_INVISIBILITY_ELIXIR);
        AlchemistCauldronTile.createBottleEmptyInteraction((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map, ItemRegistry.GREATER_HEALING_POTION);
        NeoForge.EVENT_BUS.post((Event)new AlchemistCauldronBuildInteractionsEvent((Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction>)map));
        return map;
    }

    protected static void createBottleEmptyInteraction(Object2ObjectOpenHashMap<Item, AlchemistCauldronInteraction> map, Supplier<Item> item) {
        map.put((Object)item.get(), (tile, blockState, level, pos, itemstack) -> {
            for (int i = 0; i < tile.outputItems.size(); ++i) {
                ItemStack stack = (ItemStack)tile.outputItems.get(i);
                if (!stack.isEmpty()) continue;
                ItemStack input = itemstack.copy();
                input.setCount(1);
                tile.outputItems.set(i, (Object)input);
                level.playSound(null, pos, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            }
            return null;
        });
    }

    public int[] getSlotsForFace(Direction pSide) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean canPlaceItemThroughFace(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        return ((ItemStack)this.inputItems.get(pIndex)).isEmpty() && this.isValidInput(pItemStack);
    }

    public boolean canTakeItemThroughFace(int pIndex, ItemStack pStack, Direction pDirection) {
        return false;
    }

    public void clearContent() {
        this.inputItems.clear();
        this.outputItems.clear();
    }

    public int getContainerSize() {
        return MAX_LEVELS;
    }

    public boolean isEmpty() {
        return this.inputItems.stream().allMatch(ItemStack::isEmpty);
    }

    public ItemStack getItem(int pSlot) {
        return pSlot >= 0 && pSlot <= this.inputItems.size() ? (ItemStack)this.inputItems.get(pSlot) : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        return pSlot >= 0 && pSlot <= this.inputItems.size() ? (ItemStack)this.inputItems.remove(pSlot) : ItemStack.EMPTY;
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        return pSlot >= 0 && pSlot <= this.inputItems.size() ? (ItemStack)this.inputItems.remove(pSlot) : ItemStack.EMPTY;
    }

    public void setItem(int pSlot, ItemStack pStack) {
        if (pSlot >= 0 && pSlot <= this.inputItems.size()) {
            this.inputItems.set(pSlot, (Object)pStack);
        }
    }

    public boolean isBoiling(BlockState blockState) {
        return AlchemistCauldronBlock.isLit(blockState) && this.getLiquidLevel() >= 1;
    }

    public int getLiquidLevel() {
        return this.outputItems.stream().filter(itemstack -> !itemstack.isEmpty()).toList().size();
    }
}

