/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.block.alchemist_cauldron;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.redspace.ironsspellbooks.block.alchemist_cauldron.AlchemistCauldronTile;
import io.redspace.ironsspellbooks.render.RenderHelper;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Display;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class AlchemistCauldronRenderer
implements BlockEntityRenderer<AlchemistCauldronTile> {
    ItemRenderer itemRenderer;
    private static final Vec3 ITEM_POS = new Vec3(0.5, 1.5, 0.5);

    public AlchemistCauldronRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(AlchemistCauldronTile cauldron, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        int waterLevel = cauldron.getLiquidLevel();
        float waterOffset = Mth.lerp((float)((float)waterLevel / (float)AlchemistCauldronTile.MAX_LEVELS), (float)0.25f, (float)0.9f);
        if (waterLevel > 0) {
            this.renderWater(cauldron, poseStack, bufferSource, packedLight, waterOffset);
        }
        NonNullList<ItemStack> floatingItems = cauldron.inputItems;
        for (int i = 0; i < floatingItems.size(); ++i) {
            ItemStack itemStack = (ItemStack)floatingItems.get(i);
            if (itemStack.isEmpty()) continue;
            float f = waterLevel > 0 ? (float)cauldron.getLevel().getGameTime() + partialTick : 15.0f;
            Vec2 floatOffset = this.getFloatingItemOffset(f, i * 587);
            float yRot = (f + (float)(i * 213)) / (float)(i + 1) * 1.5f;
            this.renderItem(itemStack, new Vec3((double)floatOffset.x, (double)(waterOffset + (float)i * 0.01f), (double)floatOffset.y), yRot, cauldron, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        }
        MinecraftInstanceHelper.ifPlayerPresent(player -> {
            if (Math.abs(player.getX() - (double)cauldron.getBlockPos().getX()) < 5.0 && Math.abs(player.getY() - (double)cauldron.getBlockPos().getY()) < 5.0 && Math.abs(player.getZ() - (double)cauldron.getBlockPos().getZ()) < 5.0 && player.isCrouching()) {
                for (int i = 0; i < cauldron.outputItems.size(); ++i) {
                    MobEffectInstance primaryEffect;
                    PotionContents contents;
                    Iterator itr;
                    ItemStack itemStack = (ItemStack)cauldron.outputItems.get(i);
                    if (itemStack.isEmpty()) continue;
                    MutableComponent component = Component.translatable((String)itemStack.getDescriptionId());
                    if (itemStack.has(DataComponents.POTION_CONTENTS) && (itr = (contents = (PotionContents)itemStack.get(DataComponents.POTION_CONTENTS)).getAllEffects().iterator()).hasNext() && (primaryEffect = (MobEffectInstance)itr.next()).getAmplifier() > 0) {
                        component.append((Component)Component.literal((String)String.format(" (%s)", this.simpleRomanNumeral(primaryEffect.getAmplifier() + 1))));
                    }
                    this.renderWorldText(itemStack, (Component)component, Display.TextDisplay.Align.LEFT, new Vec3(0.5, 1.1 + (double)i * 0.25, 0.5), poseStack, bufferSource, packedLight, partialTick);
                }
            }
        });
    }

    private String simpleRomanNumeral(int num) {
        return switch (num) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            case 6 -> "VI";
            case 7 -> "VII";
            case 8 -> "VIII";
            case 9 -> "IX";
            case 10 -> "X";
            default -> String.valueOf(num);
        };
    }

    public void renderWorldText(ItemStack stack, Component text, Display.TextDisplay.Align alignment, Vec3 offset, PoseStack poseStack, MultiBufferSource pBuffer, int pLightmapUV, float pPartialTick) {
        boolean seeTextThroughBlocks = false;
        boolean dropShadow = false;
        int opacity = -1;
        float f = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int i = (int)(f * 255.0f) << 24;
        text = Component.literal((String)"    ").append(text);
        float f2 = 0.0f;
        poseStack.pushPose();
        poseStack.translate((float)offset.x, (float)offset.y, (float)offset.z);
        poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        Matrix4f matrix4f = poseStack.last().pose();
        matrix4f.rotate((float)Math.PI, 0.0f, 1.0f, 0.0f);
        matrix4f.scale(-0.025f, -0.025f, -0.025f);
        Font font = Minecraft.getInstance().font;
        int lineHeight = 10;
        float customScale = 0.7f;
        int textWidth = (int)((float)font.width((FormattedText)text) * 0.7f) + lineHeight;
        int textHeight = (int)((float)lineHeight * 0.85f);
        matrix4f.translate(1.0f - (float)textWidth / 2.0f, (float)(-textHeight), 0.0f);
        if (i != 0) {
            RenderHelper.quadBuilder().matrix(matrix4f).color(i).light(pLightmapUV).vertex(-1.0f, -1.0f, 0.0f).vertex(-1.0f, textHeight, 0.0f).vertex(textWidth, textHeight, 0.0f).vertex(textWidth, -1.0f, 0.0f).build(pBuffer.getBuffer(RenderType.textBackground()));
        }
        float f1 = 0.0f;
        matrix4f.scale(customScale);
        matrix4f.translate(0.0f, (float)lineHeight * (1.0f - customScale) * 0.5f, 0.0f);
        font.drawInBatch(text, f1 + (float)lineHeight / 2.0f, f2, opacity << 24 | 0xFFFFFF, dropShadow, matrix4f, pBuffer, seeTextThroughBlocks ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.POLYGON_OFFSET, 0, pLightmapUV);
        poseStack.pushPose();
        poseStack.scale(-16.0f, -16.0f, -16.0f);
        poseStack.translate(-0.5, -0.25, -0.1);
        this.itemRenderer.renderStatic(stack, ItemDisplayContext.FIXED, pLightmapUV, OverlayTexture.NO_OVERLAY, poseStack, pBuffer, null, 0);
        poseStack.popPose();
        poseStack.popPose();
    }

    public Vec2 getFloatingItemOffset(float time, int offset) {
        float xspeed = offset % 2 == 0 ? 0.0075f : 0.025f * (1.0f + (float)(offset % 88) * 0.001f);
        float yspeed = offset % 2 == 0 ? 0.025f : 0.0075f * (1.0f + (float)(offset % 88) * 0.001f);
        float x = (time + (float)offset) * xspeed;
        x = (Math.abs(x % 2.0f - 1.0f) + 1.0f) / 2.0f;
        float y = (time + (float)offset + 4356.0f) * yspeed;
        y = (Math.abs(y % 2.0f - 1.0f) + 1.0f) / 2.0f;
        x = Mth.lerp((float)x, (float)-0.2f, (float)0.75f);
        y = Mth.lerp((float)y, (float)-0.2f, (float)0.75f);
        return new Vec2(x, y);
    }

    private void renderWater(AlchemistCauldronTile cauldron, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, float waterOffset) {
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.beaconBeam((ResourceLocation)new ResourceLocation("irons_spellbooks", "textures/block/water_still.png"), (boolean)true));
        long color = cauldron.getAverageWaterColor();
        Vector3f rgb = this.colorFromLong(color);
        Matrix4f pose = poseStack.last().pose();
        int frames = 32;
        float frameSize = 1.0f / (float)frames;
        long frame = cauldron.getLevel().getGameTime() / 3L % (long)frames;
        float min_u = 0.0f;
        float max_u = 1.0f;
        float min_v = frameSize * (float)frame;
        float max_v = frameSize * (float)(frame + 1L);
        consumer.addVertex(pose, 1.0f, waterOffset, 0.0f).setColor(rgb.x(), rgb.y(), rgb.z(), 1.0f).setUv(max_u, min_v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, 0.0f, waterOffset, 0.0f).setColor(rgb.x(), rgb.y(), rgb.z(), 1.0f).setUv(min_u, min_v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, 0.0f, waterOffset, 1.0f).setColor(rgb.x(), rgb.y(), rgb.z(), 1.0f).setUv(min_u, max_v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, 1.0f, waterOffset, 1.0f).setColor(rgb.x(), rgb.y(), rgb.z(), 1.0f).setUv(max_u, max_v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(0.0f, 1.0f, 0.0f);
    }

    private Vector3f colorFromLong(long color) {
        return new Vector3f((float)(color >> 16 & 0xFFL) / 255.0f, (float)(color >> 8 & 0xFFL) / 255.0f, (float)(color & 0xFFL) / 255.0f);
    }

    private void renderItem(ItemStack itemStack, Vec3 offset, float yRot, AlchemistCauldronTile tile, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        int renderId = (int)tile.getBlockPos().asLong();
        poseStack.translate(offset.x, offset.y, offset.z);
        poseStack.mulPose(Axis.YP.rotationDegrees(yRot));
        poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        poseStack.scale(0.4f, 0.4f, 0.4f);
        this.itemRenderer.renderStatic(itemStack, ItemDisplayContext.FIXED, LevelRenderer.getLightColor((BlockAndTintGetter)tile.getLevel(), (BlockPos)tile.getBlockPos()), packedOverlay, poseStack, bufferSource, tile.getLevel(), renderId);
        poseStack.popPose();
    }
}

