/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.block.alchemist_cauldron;

import io.redspace.ironsspellbooks.api.util.Utils;
import net.minecraft.core.Holder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.ItemLike;

public class AlchemistCauldronRecipe {
    private final ItemStack inputStack;
    private final ItemStack ingredientStack;
    private final ItemStack resultStack;
    private int requiredBaseCount = 1;
    private int resultLimitCount = 4;

    public AlchemistCauldronRecipe(ItemStack inputStack, ItemStack ingredientStack, ItemStack resultStack) {
        this.inputStack = inputStack;
        this.ingredientStack = ingredientStack;
        this.resultStack = resultStack;
    }

    public AlchemistCauldronRecipe(Item input, Item ingredient, Item result) {
        this(new ItemStack((ItemLike)input), new ItemStack((ItemLike)ingredient), new ItemStack((ItemLike)result));
    }

    public AlchemistCauldronRecipe(Holder<Potion> input, Item ingredient, Item result) {
        this(Utils.setPotion(new ItemStack((ItemLike)Items.POTION), input), new ItemStack((ItemLike)ingredient), new ItemStack((ItemLike)result));
    }

    public AlchemistCauldronRecipe setBaseRequirement(int i) {
        this.requiredBaseCount = i;
        return this;
    }

    public AlchemistCauldronRecipe setResultLimit(int i) {
        this.resultLimitCount = i;
        return this;
    }

    public ItemStack createOutput(ItemStack input, ItemStack ingredient, boolean ignoreCount, boolean consumeOnSuccess) {
        if (ItemStack.isSameItemSameComponents((ItemStack)input, (ItemStack)this.inputStack) && ItemStack.isSameItemSameComponents((ItemStack)ingredient, (ItemStack)this.ingredientStack) && (ignoreCount || input.getCount() >= this.requiredBaseCount)) {
            ItemStack result = this.resultStack.copy();
            result.setCount(this.resultLimitCount);
            if (consumeOnSuccess) {
                input.shrink(this.requiredBaseCount);
                ingredient.shrink(1);
            }
            return result;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack getInput() {
        ItemStack i = this.inputStack.copy();
        i.setCount(this.requiredBaseCount);
        return i;
    }

    public ItemStack getIngredient() {
        return this.ingredientStack.copy();
    }

    public ItemStack getResult() {
        ItemStack i = this.resultStack.copy();
        i.setCount(this.resultLimitCount);
        return i;
    }
}

