/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.item.curios;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.registries.ComponentRegistry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record AffinityData(String spellId, int bonus) {
    public static final Codec<AffinityData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("id").forGetter(data -> data.spellId), (App)Codec.INT.optionalFieldOf("bonus", (Object)1).forGetter(data -> data.bonus)).apply((Applicative)builder, AffinityData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, AffinityData> STREAM_CODEC = StreamCodec.of((buf, data) -> {
        buf.writeUtf(data.spellId);
        buf.writeInt(data.bonus);
    }, buf -> new AffinityData(buf.readUtf(), buf.readInt()));
    public static final AffinityData NONE = new AffinityData(SpellRegistry.none().getSpellId());

    private AffinityData(String id) {
        this(id, 1);
    }

    private AffinityData(AbstractSpell spell) {
        this(spell.getSpellId());
    }

    public static AffinityData getAffinityData(ItemStack stack) {
        return stack.has(ComponentRegistry.AFFINITY_COMPONENT) ? (AffinityData)stack.get(ComponentRegistry.AFFINITY_COMPONENT) : NONE;
    }

    public static void setAffinityData(ItemStack stack, AbstractSpell spell) {
        stack.set((DataComponentType)ComponentRegistry.AFFINITY_COMPONENT.value(), (Object)new AffinityData(spell));
    }

    public static boolean hasAffinityData(ItemStack itemStack) {
        return itemStack.has(ComponentRegistry.AFFINITY_COMPONENT);
    }

    public AbstractSpell getSpell() {
        return SpellRegistry.getSpell(this.spellId);
    }

    public String getNameForItem() {
        return this.getSpell() == SpellRegistry.none() ? Component.translatable((String)"tooltip.irons_spellbooks.no_affinity").getString() : this.getSpell().getSchoolType().getDisplayName().getString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof AffinityData)) return false;
        AffinityData affinityData = (AffinityData)obj;
        if (!affinityData.spellId.equals(this.spellId)) return false;
        if (this.bonus != affinityData.bonus) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.spellId.hashCode() * 31 + this.bonus;
    }
}

