/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.item;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.redspace.ironsspellbooks.item.armor.UpgradeType;
import io.redspace.ironsspellbooks.registries.ComponentRegistry;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectObjectImmutablePair;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public record UpgradeData(ImmutableMap<UpgradeType, Integer> upgrades, String upgradedSlot) {
    public static final String Upgrades = "ISBUpgrades";
    public static final String UPGRADE_TYPE = "id";
    public static final String SLOT = "slot";
    public static final String COUNT = "count";
    public static final String UPGRADES = "upgrades";
    public static final UpgradeData NONE = new UpgradeData((ImmutableMap<UpgradeType, Integer>)ImmutableMap.of(), EquipmentSlot.MAINHAND.getName());
    private static final Codec<ObjectObjectImmutablePair<String, Integer>> ELEMENT_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf(UPGRADE_TYPE).forGetter(Pair::left), (App)Codec.INT.fieldOf(COUNT).forGetter(Pair::right)).apply((Applicative)builder, ObjectObjectImmutablePair::new));
    public static final Codec<UpgradeData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf(SLOT).forGetter(UpgradeData::getUpgradedSlot), (App)Codec.list(ELEMENT_CODEC).fieldOf(UPGRADES).forGetter(data -> data.getUpgrades().entrySet().stream().map(entry -> new ObjectObjectImmutablePair((Object)((UpgradeType)entry.getKey()).getId().toString(), (Object)((Integer)entry.getValue()))).toList())).apply((Applicative)builder, (slot, list) -> new UpgradeData(UpgradeData.parseCodec(list), (String)slot)));
    public static final StreamCodec<FriendlyByteBuf, UpgradeData> STREAM_CODEC = StreamCodec.of((buf, data) -> {
        buf.writeUtf(data.upgradedSlot);
        ImmutableSet entries = data.upgrades.entrySet();
        buf.writeInt(entries.size());
        for (Map.Entry entry : entries) {
            buf.writeUtf(((UpgradeType)entry.getKey()).getId().toString());
            buf.writeInt(((Integer)entry.getValue()).intValue());
        }
    }, buf -> {
        String slot = buf.readUtf();
        int i = buf.readInt();
        ImmutableMap.Builder upgrades = ImmutableMap.builder();
        for (int j = 0; j < i; ++j) {
            ResourceLocation upgradeKey = ResourceLocation.parse((String)buf.readUtf());
            int c = buf.readInt();
            UpgradeType.getUpgrade(upgradeKey).ifPresent(upgrade -> upgrades.put(upgrade, (Object)c));
        }
        return new UpgradeData((ImmutableMap<UpgradeType, Integer>)upgrades.build(), slot);
    });

    private static ImmutableMap<UpgradeType, Integer> parseCodec(List<ObjectObjectImmutablePair<String, Integer>> data) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (Pair pair : data) {
            ResourceLocation upgradeKey = ResourceLocation.parse((String)((String)pair.left()));
            UpgradeType.getUpgrade(upgradeKey).ifPresent(upgrade -> map.put(upgrade, (Object)((Integer)pair.right())));
        }
        return map.build();
    }

    public static UpgradeData getUpgradeData(ItemStack itemStack) {
        if (!itemStack.has(ComponentRegistry.UPGRADE_DATA)) {
            return NONE;
        }
        return (UpgradeData)itemStack.get(ComponentRegistry.UPGRADE_DATA);
    }

    public UpgradeData addUpgrade(ItemStack stack, UpgradeType upgradeType, String slot) {
        if (this == NONE) {
            ImmutableMap.Builder map = ImmutableMap.builder();
            map.put((Object)upgradeType, (Object)1);
            UpgradeData upgrade = new UpgradeData((ImmutableMap<UpgradeType, Integer>)map.build(), slot);
            stack.set(ComponentRegistry.UPGRADE_DATA, (Object)upgrade);
            return upgrade;
        }
        ImmutableMap.Builder map = ImmutableMap.builder();
        if (this.upgrades.containsKey((Object)upgradeType)) {
            map.put((Object)upgradeType, (Object)((Integer)this.upgrades.get((Object)upgradeType) + 1));
            map.putAll(this.upgrades.entrySet().stream().filter(entry -> entry.getKey() != upgradeType).toList());
        } else {
            map.put((Object)upgradeType, (Object)1);
            map.putAll(this.upgrades);
        }
        UpgradeData upgrade = new UpgradeData((ImmutableMap<UpgradeType, Integer>)map.build(), this.upgradedSlot);
        stack.set(ComponentRegistry.UPGRADE_DATA, (Object)upgrade);
        return upgrade;
    }

    public int getTotalUpgrades() {
        int count = 0;
        for (Map.Entry upgradeInstance : this.upgrades.entrySet()) {
            count += ((Integer)upgradeInstance.getValue()).intValue();
        }
        return count;
    }

    public String getUpgradedSlot() {
        return this.upgradedSlot;
    }

    public Map<UpgradeType, Integer> getUpgrades() {
        return this.upgrades;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof UpgradeData)) return false;
        UpgradeData upgradeData = (UpgradeData)obj;
        if (!this.upgradedSlot.equals(upgradeData.upgradedSlot)) return false;
        if (!this.upgrades.equals(upgradeData.upgrades)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return this.upgradedSlot.hashCode() * 31 + this.upgrades.hashCode();
    }
}

