/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.weathergate.util;

import com.mojang.serialization.Codec;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.NotNull;

public enum Type implements StringRepresentable
{
    GRASS("grass", ItemIcon.getItemIcon((Item)Items.GRASS_BLOCK), (biome, blockPos) -> biome.getSpecialEffects().getGrassColorOverride().map(Color4I::rgb).orElse(Color4I.GREEN)),
    FOLIAGE("foliage", ItemIcon.getItemIcon((Item)Items.OAK_LEAVES), (biome, blockPos) -> biome.getSpecialEffects().getFoliageColorOverride().map(Color4I::rgb).orElse(Color4I.GREEN)),
    WATER("water", ItemIcon.getItemIcon((Item)Items.WATER_BUCKET), (biome, blockPos) -> Color4I.rgb((int)biome.getWaterColor()));

    public static final Codec<Type> CODEC;
    public static final StreamCodec<FriendlyByteBuf, Type> STREAM_CODEC;
    private final BiFunction<Biome, BlockPos, Color4I> defaultColor;
    private final String name;
    private final Icon icon;

    private Type(String name, Icon icon, BiFunction<Biome, BlockPos, Color4I> defaultColor) {
        this.name = name;
        this.defaultColor = defaultColor;
        this.icon = icon;
    }

    public String getLangKey() {
        return "weathergate.type." + this.name;
    }

    public Component getComponent() {
        return Component.translatable((String)this.getLangKey());
    }

    public Icon getIcon() {
        return this.icon;
    }

    public BiFunction<Biome, BlockPos, Color4I> getDefaultColor() {
        return this.defaultColor;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(Type::values);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Type.class);
    }
}

