/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.weathergate.level.attachments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unrealdinnerbone.weathergate.WeatherGateCodecs;
import com.unrealdinnerbone.weathergate.WeatherGateRegistry;
import com.unrealdinnerbone.weathergate.util.Type;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.attachment.AttachmentType;

public record TerrainControllerAttachment(Map<BlockPos, Map<Type, Color4I>> data) {
    public static final TerrainControllerAttachment EMPTY = new TerrainControllerAttachment(new HashMap<BlockPos, Map<Type, Color4I>>());
    public static final Codec<TerrainControllerAttachment> CODEC = Data.CODEC.listOf().xmap(TerrainControllerAttachment::of, TerrainControllerAttachment::asList);

    public static TerrainControllerAttachment of(List<Data> data) {
        HashMap<BlockPos, Map<Type, Color4I>> map = new HashMap<BlockPos, Map<Type, Color4I>>();
        data.forEach(blockPos -> map.put(blockPos.blockPos(), blockPos.data()));
        return new TerrainControllerAttachment(map);
    }

    public List<Data> asList() {
        ArrayList<Data> dataList = new ArrayList<Data>();
        this.data.forEach((pos, map) -> dataList.add(Data.of(pos, map)));
        return dataList;
    }

    public void save(Level level) {
        level.setData((AttachmentType)WeatherGateRegistry.TERIANN_CONTROLLER_ATTACHMENT.get(), (Object)this);
    }

    public static TerrainControllerAttachment getAttachment(Level level) {
        return (TerrainControllerAttachment)level.getData((AttachmentType)WeatherGateRegistry.TERIANN_CONTROLLER_ATTACHMENT.get());
    }

    public Map<Type, Color4I> getAttachmentData(BlockPos pos) {
        return this.data.get(pos);
    }

    public record Data(BlockPos blockPos, Map<Type, Color4I> data) {
        public static final Codec<Data> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockPos.CODEC.fieldOf("pos").forGetter(Data::blockPos), (App)Codec.unboundedMap(Type.CODEC, WeatherGateCodecs.COLOR4I_CODEC).fieldOf("data").forGetter(Data::data)).apply((Applicative)instance, Data::of));

        public static Data of(BlockPos blockPos, Map<Type, Color4I> data) {
            return new Data(blockPos, new HashMap<Type, Color4I>(data));
        }
    }
}

