/*
 * Decompiled with CFR 0.152.
 */
package com.unrealdinnerbone.weathergate.client.screen;

import com.mojang.logging.LogUtils;
import com.unrealdinnerbone.weathergate.network.packets.c2s.UpdateControllerPacket;
import com.unrealdinnerbone.weathergate.util.Type;
import dev.ftb.mods.ftblibrary.config.ColorConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.ColorSelectorPanel;
import dev.ftb.mods.ftblibrary.ui.ModalPanel;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractButtonListScreen;
import dev.ftb.mods.ftblibrary.ui.misc.NordColors;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class TerrainControllerScreen2
extends AbstractButtonListScreen
implements NordColors {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final BlockPos blockPos;
    private final Map<Type, Color4I> color4IMap;

    public TerrainControllerScreen2(BlockPos blockPos, Map<Type, Color4I> color4IMap) {
        this.blockPos = blockPos;
        this.color4IMap = color4IMap;
        this.setWidth(60);
        this.setHeight(65);
        this.showBottomPanel(false);
    }

    @NotNull
    private SimpleButton createSimpleButton(Panel panel, Type value) {
        Color4I[] activeValue = new Color4I[]{this.color4IMap.getOrDefault((Object)value, Color4I.WHITE)};
        return new MySimpleButton(this, panel, value, activeValue);
    }

    protected void doCancel() {
    }

    protected void doAccept() {
    }

    public void addButtons(Panel panel) {
        Arrays.stream(Type.values()).forEach(value -> panel.add((Widget)this.createSimpleButton(panel, (Type)((Object)value))));
    }

    private class MySimpleButton
    extends SimpleButton {
        private final Color4I[] activeValue;
        private final Type value;

        public MySimpleButton(TerrainControllerScreen2 terrainControllerScreen2, Panel panel, Type value, Color4I[] activeValue) {
            super(panel, value.getComponent(), value.getIcon(), (button, mouseButton) -> {
                ColorConfig config = new ColorConfig();
                config.setValue((Object)activeValue[0]);
                ColorSelectorPanel colorSelectorPanel = new ColorSelectorPanel((Panel)terrainControllerScreen2, config, accepted -> {
                    if (accepted) {
                        activeValue[0] = (Color4I)config.getValue();
                        PacketDistributor.sendToServer((CustomPacketPayload)new UpdateControllerPacket(GlobalPos.of((ResourceKey)Minecraft.getInstance().player.level().dimension(), (BlockPos)com$unrealdinnerbone$weathergate$client$screen$TerrainControllerScreen2$this.blockPos), Map.of(value, (Color4I)config.getValue())), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    }
                });
                colorSelectorPanel.setPos(com$unrealdinnerbone$weathergate$client$screen$TerrainControllerScreen2$this.width / 2 - colorSelectorPanel.width / 2, com$unrealdinnerbone$weathergate$client$screen$TerrainControllerScreen2$this.width / 2 - colorSelectorPanel.height / 2);
                colorSelectorPanel.setAllowAlphaEdit(config.isAllowAlphaEdit());
                colorSelectorPanel.getGui().pushModalPanel((ModalPanel)colorSelectorPanel);
                colorSelectorPanel.setAllowAlphaEdit(false);
                colorSelectorPanel.setExtraZlevel(100);
            });
            this.value = value;
            this.activeValue = activeValue;
        }

        public void drawIcon(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        }

        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            super.draw(graphics, theme, x, y, w, h);
            theme.drawWidget(graphics, x, y, w, h, this.getWidgetType());
            Color4I.BLACK.withAlpha(125).draw(graphics, x + 2, y + 2, 12, 12);
            this.activeValue[0].draw(graphics, x + 3, y + 3, 10, 10);
            this.icon.draw(graphics, x + 3, y + 3, 10, 10);
            theme.drawString(graphics, (Object)this.value.getComponent().getString(), x + 18, y + 4);
        }
    }
}

