/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.cobblegengalore.util;

import cy.jdkdigital.cobblegengalore.CobbleGenGalore;
import cy.jdkdigital.cobblegengalore.common.recipe.BlockGenRecipe;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class RecipeHelper {
    public static RecipeHolder<BlockGenRecipe> getRecipe(ServerLevel level, BlockPos genPos) {
        BlockState southState;
        BlockState belowState = RecipeHelper.getStateAtPos((Level)level, genPos, Direction.DOWN);
        BlockState northState = RecipeHelper.getStateAtPos((Level)level, genPos, Direction.NORTH);
        RecipeHolder<BlockGenRecipe> recipe = RecipeHelper.getRecipe((Level)level, northState, southState = RecipeHelper.getStateAtPos((Level)level, genPos, Direction.SOUTH), belowState);
        if (recipe == null) {
            BlockState eastState = RecipeHelper.getStateAtPos((Level)level, genPos, Direction.EAST);
            BlockState westState = RecipeHelper.getStateAtPos((Level)level, genPos, Direction.WEST);
            recipe = RecipeHelper.getRecipe((Level)level, eastState, westState, belowState);
        }
        return recipe;
    }

    @Nullable
    private static RecipeHolder<BlockGenRecipe> getRecipe(Level level, BlockState left, BlockState right, BlockState below) {
        List allRecipes = level.getRecipeManager().getAllRecipesFor((RecipeType)CobbleGenGalore.BLOCKGEN_RECIPE_TYPE.get());
        RecipeHolder matchingRecipe = null;
        for (RecipeHolder recipeHolder : allRecipes) {
            if (!((BlockGenRecipe)recipeHolder.value()).matches(left, right, below)) continue;
            if (matchingRecipe != null) {
                matchingRecipe = ((BlockGenRecipe)matchingRecipe.value()).modifier.isAir() ? recipeHolder : matchingRecipe;
                continue;
            }
            matchingRecipe = recipeHolder;
        }
        return matchingRecipe;
    }

    public static BlockState getStateAtPos(Level level, BlockPos pos, Direction dir) {
        IFluidHandler northCap = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos.relative(dir), (Object)dir.getOpposite());
        BlockState state = northCap != null ? northCap.getFluidInTank(0).getFluid().defaultFluidState().createLegacyBlock() : level.getBlockState(pos.relative(dir));
        return state;
    }

    public static int consumeFluid(Level level, BlockPos pos, Direction dir, int count, boolean simulate) {
        IFluidHandler fluidCap = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos.relative(dir), (Object)dir.getOpposite());
        if (fluidCap != null) {
            int removedAmount = (int)Math.min((double)count, Math.floor((float)fluidCap.getFluidInTank(0).getAmount() / 1000.0f));
            if (removedAmount > 0) {
                if (!simulate) {
                    fluidCap.getFluidInTank(0).shrink(1000 * removedAmount);
                }
                return removedAmount;
            }
            return 0;
        }
        if (!simulate) {
            level.setBlockAndUpdate(pos.relative(dir), Blocks.AIR.defaultBlockState());
        }
        return 1;
    }
}

