/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.cobblegengalore.common.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.cobblegengalore.CobbleGenGalore;
import cy.jdkdigital.cobblegengalore.common.block.entity.BlockGenBlockEntity;
import cy.jdkdigital.cobblegengalore.util.RecipeHelper;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BlockGenBlock
extends BaseEntityBlock {
    public static final MapCodec<BlockGenBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BlockGenBlock.propertiesCodec(), (App)Codec.INT.fieldOf("modifier").forGetter(block -> block.modifier)).apply((Applicative)builder, BlockGenBlock::new));
    public final int modifier;

    public BlockGenBlock(BlockBehaviour.Properties properties, int modifier) {
        super(properties);
        this.modifier = modifier;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new BlockGenBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? BlockGenBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)CobbleGenGalore.BLOCKGEN_BLOCKENTITY.get()), BlockGenBlockEntity::clientTick) : BlockGenBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)CobbleGenGalore.BLOCKGEN_BLOCKENTITY.get()), BlockGenBlockEntity::serverTick);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BlockGenBlockEntity) {
            BlockGenBlockEntity blockEntity2 = (BlockGenBlockEntity)blockEntity;
            if (!blockEntity2.getBuffer().isEmpty()) {
                ItemStack itemInHand = player.getItemInHand(InteractionHand.MAIN_HAND);
                if (ItemStack.isSameItemSameComponents((ItemStack)itemInHand, (ItemStack)blockEntity2.getBuffer())) {
                    int addedCount = Math.min(itemInHand.getMaxStackSize() - itemInHand.getCount(), blockEntity2.getBuffer().getCount());
                    itemInHand.grow(addedCount);
                    blockEntity2.getBuffer().shrink(addedCount);
                } else if (itemInHand.isEmpty()) {
                    ItemStack addedStack = blockEntity2.getBuffer().copy();
                    addedStack.setCount(Math.min(addedStack.getCount(), addedStack.getMaxStackSize()));
                    player.setItemInHand(InteractionHand.MAIN_HAND, addedStack);
                    if (addedStack.getCount() == blockEntity2.getBuffer().getCount()) {
                        blockEntity2.clearBuffer();
                    } else {
                        blockEntity2.getBuffer().shrink(addedStack.getCount());
                    }
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        this.refreshRecipe(level, pos);
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        this.refreshRecipe(level, pos);
    }

    private void refreshRecipe(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof BlockGenBlockEntity) {
                BlockGenBlockEntity blockEntity2 = (BlockGenBlockEntity)blockEntity;
                blockEntity2.setRecipe(RecipeHelper.getRecipe(serverLevel, pos));
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"block_gen.tooltip", (Object[])new Object[]{this.modifier}).withStyle(ChatFormatting.GOLD));
    }
}

