/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.server.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.AffixRegistry;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.item.ChampionEggItem;
import top.theillusivec4.champions.common.registry.ModItems;
import top.theillusivec4.champions.common.util.ChampionBuilder;
import top.theillusivec4.champions.server.command.AffixArgumentType;

public class ChampionsCommand {
    public static final SuggestionProvider<CommandSourceStack> AFFIXES = SuggestionProviders.register((ResourceLocation)Champions.getLocation("affixes"), (context, builder) -> SharedSuggestionProvider.suggestResource((Iterable)AffixRegistry.AFFIX_REGISTRY.keySet(), (SuggestionsBuilder)builder));
    public static final SuggestionProvider<CommandSourceStack> MONSTER_ENTITIES = SuggestionProviders.register((ResourceLocation)Champions.getLocation("monster_entities"), (context, builder) -> SharedSuggestionProvider.suggestResource(BuiltInRegistries.ENTITY_TYPE.stream().filter(type -> type.getCategory() == MobCategory.MONSTER), (SuggestionsBuilder)builder, EntityType::getKey, type -> Component.translatable((String)Util.makeDescriptionId((String)"entity", (ResourceLocation)EntityType.getKey((EntityType)type)))));
    private static final DynamicCommandExceptionType UNKNOWN_ENTITY = new DynamicCommandExceptionType(type -> Component.translatable((String)"command.champions.egg.unknown_entity", (Object[])new Object[]{type}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        int opPermissionLevel = 2;
        LiteralArgumentBuilder championsCommand = (LiteralArgumentBuilder)Commands.literal((String)"champions").requires(player -> player.hasPermission(opPermissionLevel));
        championsCommand.then(Commands.literal((String)"egg").then(Commands.argument((String)"entity", (ArgumentType)ResourceLocationArgument.id()).suggests(MONSTER_ENTITIES).then(((RequiredArgumentBuilder)Commands.argument((String)"tier", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ChampionsCommand.createEgg((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), new ArrayList<IAffix>()))).then(Commands.argument((String)"affixes", (ArgumentType)AffixArgumentType.affix()).suggests(AFFIXES).executes(context -> ChampionsCommand.createEgg((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), AffixArgumentType.getAffixes((CommandContext<CommandSourceStack>)context, "affixes")))))));
        championsCommand.then(Commands.literal((String)"summon").then(Commands.argument((String)"entity", (ArgumentType)ResourceLocationArgument.id()).suggests(MONSTER_ENTITIES).then(((RequiredArgumentBuilder)Commands.argument((String)"tier", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ChampionsCommand.summon((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), new ArrayList<IAffix>()))).then(Commands.argument((String)"affixes", (ArgumentType)AffixArgumentType.affix()).suggests(AFFIXES).executes(context -> ChampionsCommand.summon((CommandSourceStack)context.getSource(), ResourceLocationArgument.getId((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), AffixArgumentType.getAffixes((CommandContext<CommandSourceStack>)context, "affixes")))))));
        championsCommand.then(Commands.literal((String)"summonpos").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.argument((String)"entity", (ArgumentType)ResourceLocationArgument.id()).suggests(MONSTER_ENTITIES).then(((RequiredArgumentBuilder)Commands.argument((String)"tier", (ArgumentType)IntegerArgumentType.integer()).executes(context -> ChampionsCommand.summon((CommandSourceStack)context.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)context, (String)"pos"), ResourceLocationArgument.getId((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), new ArrayList<IAffix>()))).then(Commands.argument((String)"affixes", (ArgumentType)AffixArgumentType.affix()).suggests(AFFIXES).executes(context -> ChampionsCommand.summon((CommandSourceStack)context.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)context, (String)"pos"), ResourceLocationArgument.getId((CommandContext)context, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)context, (String)"tier"), AffixArgumentType.getAffixes((CommandContext<CommandSourceStack>)context, "affixes"))))))));
        dispatcher.register(championsCommand);
    }

    private static int summon(CommandSourceStack source, ResourceLocation resourceLocation, int tier, Collection<IAffix> affixes) throws CommandSyntaxException {
        return ChampionsCommand.summon(source, null, resourceLocation, tier, affixes);
    }

    private static int summon(CommandSourceStack source, @Nullable BlockPos pos, ResourceLocation resourceLocation, int tier, Collection<IAffix> affixes) throws CommandSyntaxException {
        EntityType<?> entityType = ChampionsCommand.getTypeOrThrow(resourceLocation);
        ServerPlayer sourceEntity = source.getPlayerOrException();
        Entity entity = entityType.create((ServerLevel)sourceEntity.level(), null, pos != null ? pos : new BlockPos((Vec3i)sourceEntity.blockPosition()), MobSpawnType.COMMAND, false, false);
        ChampionAttachment.getAttachment(entity).ifPresent(champion -> {
            ChampionBuilder.spawnPreset(champion, tier, new ArrayList<IAffix>(affixes));
            source.getLevel().addFreshEntity((Entity)champion.getLivingEntity());
            source.sendSuccess(() -> Component.translatable((String)"commands.champions.summon.success", (Object[])new Object[]{Component.translatable((String)("rank.champions.title." + tier)).getString() + " " + entity.getDisplayName().getString()}), false);
        });
        return 1;
    }

    private static int createEgg(CommandSourceStack source, ResourceLocation resourceLocation, int tier, Collection<IAffix> affixes) throws CommandSyntaxException {
        EntityType<?> entityType = ChampionsCommand.getTypeOrThrow(resourceLocation);
        ServerPlayer player = source.getPlayerOrException();
        ItemStack egg = new ItemStack((ItemLike)ModItems.CHAMPION_EGG_ITEM.get());
        ChampionEggItem.write(egg, ChampionsCommand.getEntityKey(entityType), tier, affixes);
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)egg, (int)1);
        source.sendSuccess(() -> Component.translatable((String)"commands.champions.egg.success", (Object[])new Object[]{egg.getDisplayName()}), false);
        return 1;
    }

    public static void createEgg(Player player, EntityType<?> entityType, int tier, Collection<IAffix> affixes) {
        ItemStack egg = new ItemStack((ItemLike)ModItems.CHAMPION_EGG_ITEM.get());
        if (player.getInventory().hasAnyOf(Set.of(egg.getItem()))) {
            return;
        }
        ChampionEggItem.write(egg, ChampionsCommand.getEntityKey(entityType), tier, affixes);
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)egg);
    }

    private static ResourceLocation getEntityKey(EntityType<?> entityType) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
    }

    private static EntityType<?> getTypeOrThrow(ResourceLocation resourceLocation) throws CommandSyntaxException {
        return (EntityType)BuiltInRegistries.ENTITY_TYPE.getOptional(resourceLocation).orElseThrow(() -> UNKNOWN_ENTITY.create((Object)resourceLocation));
    }
}

