/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.util;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.AffixManager;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.util.ChampionBuilder;
import top.theillusivec4.champions.common.util.ChampionHelper;
import top.theillusivec4.champions.common.util.EntityManager;

public class ChampionData {
    private static final String CHAMPION_KEY = "ChampionsData";
    private static final RandomSource RAND = RandomSource.create();

    public static boolean read(IChampion champion) {
        CompoundTag championTag;
        LivingEntity livingEntity = champion.getLivingEntity();
        CompoundTag tag = livingEntity.getPersistentData();
        if (!tag.isEmpty() && !(championTag = tag.getCompound(CHAMPION_KEY)).isEmpty()) {
            Rank rank = RankManager.getLowestRank();
            if (championTag.contains("tier")) {
                if (championTag.contains("tier", 3)) {
                    rank = RankManager.getRank(championTag.getInt("tier"));
                } else if (championTag.contains("tier", 10)) {
                    CompoundTag valueTag = championTag.getCompound("tier");
                    Integer min = valueTag.contains("min") ? Integer.valueOf(valueTag.getInt("min")) : null;
                    Integer max = valueTag.contains("max") ? Integer.valueOf(valueTag.getInt("max")) : null;
                    rank = ChampionData.createRank(livingEntity, min, max);
                }
            }
            champion.getServer().setRank(rank);
            ArrayList<IAffix> affixes = new ArrayList<IAffix>();
            HashSet<String> ids = new HashSet<String>();
            Integer count = null;
            if (championTag.contains("affixes")) {
                if (championTag.contains("affixes", 9)) {
                    ListTag listTag = championTag.getList("affixes", 8);
                    for (int i = 0; i < listTag.size(); ++i) {
                        ids.add(listTag.getString(i));
                    }
                } else if (championTag.contains("affixes", 10)) {
                    CompoundTag affixesTag = championTag.getCompound("affixes");
                    count = affixesTag.contains("count", 3) ? Integer.valueOf(affixesTag.getInt("count")) : null;
                    ListTag listTag = affixesTag.getList("values", 8);
                    for (int i = 0; i < listTag.size(); ++i) {
                        ids.add(listTag.getString(i));
                    }
                }
            }
            for (String id : ids) {
                Champions.API.getAffix(id).ifPresent(affixes::add);
            }
            int totalAffixes = count == null ? rank.getNumAffixes() : count.intValue();
            int toAdd = totalAffixes - affixes.size();
            if (toAdd > 0) {
                ChampionData.createAffixes(affixes, champion, totalAffixes);
            }
            ChampionBuilder.applyGrowth(livingEntity, rank.getGrowthFactor());
            champion.getServer().setAffixes(affixes);
            affixes.forEach(affix -> affix.onInitialSpawn(champion));
            return true;
        }
        return false;
    }

    private static void createAffixes(List<IAffix> affixes, IChampion champion, int total) {
        Map<AffixCategory, List<IAffix>> allAffixes = Champions.API.getCategoryMap();
        HashMap<AffixCategory, List> validAffixes = new HashMap<AffixCategory, List>();
        Optional<EntityManager.EntitySettings> entitySettings = EntityManager.getSettings(champion.getLivingEntity().getType());
        for (AffixCategory category : Champions.API.getCategories()) {
            validAffixes.put(category, new ArrayList());
        }
        allAffixes.forEach((k, v) -> ((List)validAffixes.get(k)).addAll(v.stream().filter(affix -> {
            Optional<AffixManager.AffixSettings> settings = AffixManager.getSettings(affix.getIdentifier().toString());
            return !affixes.contains(affix) && entitySettings.map(entitySettings1 -> entitySettings1.canApply((IAffix)affix)).orElse(true) != false && settings.map(affixSettings -> affixSettings.canApply(champion)).orElse(true) != false && affix.canApply(champion);
        }).toList()));
        ArrayList randomList = new ArrayList();
        validAffixes.forEach((k, v) -> randomList.addAll(v));
        while (!randomList.isEmpty() && affixes.size() < total) {
            int randomIndex = RAND.nextInt(randomList.size());
            IAffix randomAffix = (IAffix)randomList.get(randomIndex);
            if (affixes.stream().allMatch(affix -> affix.isCompatible(randomAffix) && (randomAffix.getCategory() == AffixCategory.OFFENSE || affix.getCategory() != randomAffix.getCategory()))) {
                affixes.add(randomAffix);
            }
            randomList.remove(randomIndex);
        }
    }

    private static Rank createRank(LivingEntity livingEntity, Integer min, Integer max) {
        if (ChampionHelper.isPotential(livingEntity)) {
            return RankManager.getLowestRank();
        }
        ImmutableSortedMap<Integer, Rank> ranks = RankManager.getRanks();
        if (ranks.isEmpty()) {
            Champions.LOGGER.error("No rank configuration found! Please check the 'champions-ranks.toml' file in the 'serverconfigs'.");
            return RankManager.getLowestRank();
        }
        Integer[] tierRange = new Integer[]{min, max};
        Integer firstTier = tierRange[0] != null ? tierRange[0] : (Integer)ranks.firstKey();
        int maxTier = tierRange[1] != null ? tierRange[1] : -1;
        UnmodifiableIterator iter = ranks.navigableKeySet().tailSet((Object)firstTier, false).iterator();
        Rank result = (Rank)ranks.get((Object)firstTier);
        if (result == null) {
            Champions.LOGGER.error("Tier {} cannot be found in {}! Assigning lowest available rank to {}", (Object)firstTier, ranks, (Object)livingEntity);
            return RankManager.getLowestRank();
        }
        while (iter.hasNext() && (result.getTier() < maxTier || maxTier == -1)) {
            Rank rank = (Rank)ranks.get(iter.next());
            if (rank == null) {
                return result;
            }
            float chance = rank.getChance();
            if (RAND.nextFloat() < chance) {
                result = rank;
                continue;
            }
            return result;
        }
        return result;
    }
}

