/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.registry;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import top.theillusivec4.champions.Champions;

public class ModLootTables {
    private static final Set<ResourceKey<LootTable>> LOCATIONS = new HashSet<ResourceKey<LootTable>>();
    public static final ResourceKey<LootTable> CHAMPION_LOOT = ModLootTables.create("champion_loot");
    private static final Set<ResourceKey<LootTable>> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);

    private static ResourceKey<LootTable> create(String name) {
        return ModLootTables.create((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Champions.getLocation(name)));
    }

    private static ResourceKey<LootTable> create(ResourceKey<LootTable> name) {
        if (LOCATIONS.add(name)) {
            return name;
        }
        throw new IllegalArgumentException(String.valueOf(name.location()) + " is already a registered built-in loot table");
    }

    static void bootstrap(BootstrapContext<LootTable> context) {
        HolderGetter getter = context.lookup(Registries.LOOT_TABLE);
        context.register(CHAMPION_LOOT, (Object)((LootTable)getter.getOrThrow(CHAMPION_LOOT).value()));
    }

    public static Set<ResourceKey<LootTable>> all() {
        return IMMUTABLE_LOCATIONS;
    }
}

