/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.registry;

import java.util.function.Supplier;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import top.theillusivec4.champions.api.AffixRegistry;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.common.affix.AdaptableAffix;
import top.theillusivec4.champions.common.affix.ArcticAffix;
import top.theillusivec4.champions.common.affix.DampeningAffix;
import top.theillusivec4.champions.common.affix.DesecratingAffix;
import top.theillusivec4.champions.common.affix.EnkindlingAffix;
import top.theillusivec4.champions.common.affix.HastyAffix;
import top.theillusivec4.champions.common.affix.InfestedAffix;
import top.theillusivec4.champions.common.affix.KnockingAffix;
import top.theillusivec4.champions.common.affix.LivelyAffix;
import top.theillusivec4.champions.common.affix.MagneticAffix;
import top.theillusivec4.champions.common.affix.MoltenAffix;
import top.theillusivec4.champions.common.affix.ParalyzingAffix;
import top.theillusivec4.champions.common.affix.PlaguedAffix;
import top.theillusivec4.champions.common.affix.ReflectiveAffix;
import top.theillusivec4.champions.common.affix.ShieldingAffix;
import top.theillusivec4.champions.common.affix.WoundingAffix;

public class ModAffixTypes {
    public static final DeferredHolder<IAffix, AdaptableAffix> ADAPTABLE;
    public static final DeferredHolder<IAffix, ArcticAffix> ARCTIC;
    public static final DeferredHolder<IAffix, DampeningAffix> DAMPENING;
    public static final DeferredHolder<IAffix, DesecratingAffix> DESECRATING;
    public static final DeferredHolder<IAffix, EnkindlingAffix> ENKINDLING;
    public static final DeferredHolder<IAffix, HastyAffix> HASTY;
    public static final DeferredHolder<IAffix, InfestedAffix> INFESTED;
    public static final DeferredHolder<IAffix, KnockingAffix> KNOCKING;
    public static final DeferredHolder<IAffix, LivelyAffix> LIVELY;
    public static final DeferredHolder<IAffix, MagneticAffix> MAGNETIC;
    public static final DeferredHolder<IAffix, MoltenAffix> MOLTEN;
    public static final DeferredHolder<IAffix, ParalyzingAffix> PARALYZING;
    public static final DeferredHolder<IAffix, PlaguedAffix> PLAGUED;
    public static final DeferredHolder<IAffix, ReflectiveAffix> REFLECTIVE;
    public static final DeferredHolder<IAffix, ShieldingAffix> SHIELDING;
    public static final DeferredHolder<IAffix, WoundingAffix> WOUNDING;
    private static final DeferredRegister<IAffix> AFFIXES;

    private static <I extends IAffix> DeferredHolder<IAffix, I> register(String name, Supplier<I> supplier) {
        return AFFIXES.register(name, supplier);
    }

    public static void register(IEventBus bus) {
        AFFIXES.register(bus);
    }

    static {
        AFFIXES = DeferredRegister.create(AffixRegistry.AFFIX_REGISTRY, (String)"champions");
        ADAPTABLE = ModAffixTypes.register("adaptable", AdaptableAffix::new);
        ARCTIC = ModAffixTypes.register("arctic", ArcticAffix::new);
        DAMPENING = ModAffixTypes.register("dampening", DampeningAffix::new);
        DESECRATING = ModAffixTypes.register("desecrating", DesecratingAffix::new);
        ENKINDLING = ModAffixTypes.register("enkindling", EnkindlingAffix::new);
        HASTY = ModAffixTypes.register("hasty", HastyAffix::new);
        INFESTED = ModAffixTypes.register("infested", InfestedAffix::new);
        KNOCKING = ModAffixTypes.register("knocking", KnockingAffix::new);
        LIVELY = ModAffixTypes.register("lively", LivelyAffix::new);
        MAGNETIC = ModAffixTypes.register("magnetic", MagneticAffix::new);
        MOLTEN = ModAffixTypes.register("molten", MoltenAffix::new);
        PARALYZING = ModAffixTypes.register("paralyzing", ParalyzingAffix::new);
        PLAGUED = ModAffixTypes.register("plagued", PlaguedAffix::new);
        REFLECTIVE = ModAffixTypes.register("reflective", ReflectiveAffix::new);
        SHIELDING = ModAffixTypes.register("shielding", ShieldingAffix::new);
        WOUNDING = ModAffixTypes.register("wounding", WoundingAffix::new);
    }
}

