/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.network;

import com.mojang.serialization.Codec;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionAttachment;

public record SPacketSyncChampion(int entityId, int tier, int defaultColor, Set<ResourceLocation> affixes) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SPacketSyncChampion> TYPE = new CustomPacketPayload.Type(Champions.getLocation("sync_champion"));
    public static final StreamCodec<FriendlyByteBuf, SPacketSyncChampion> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SPacketSyncChampion::entityId, (StreamCodec)ByteBufCodecs.INT, SPacketSyncChampion::tier, (StreamCodec)ByteBufCodecs.INT, SPacketSyncChampion::defaultColor, (StreamCodec)ByteBufCodecs.fromCodec((Codec)NeoForgeExtraCodecs.setOf((Codec)ResourceLocation.CODEC)), SPacketSyncChampion::affixes, SPacketSyncChampion::new);

    public static void handle(SPacketSyncChampion data, IPayloadContext cxt) {
        cxt.enqueueWork(() -> {
            ClientLevel world = Minecraft.getInstance().level;
            if (world != null) {
                Entity entity = world.getEntity(data.entityId);
                ChampionAttachment.getAttachment(entity).ifPresent(champion -> {
                    IChampion.Client clientChampion = champion.getClient();
                    clientChampion.setRank((Tuple<Integer, Integer>)new Tuple((Object)data.tier, (Object)data.defaultColor));
                    clientChampion.setAffixes(data.affixes);
                });
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

