/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public abstract class BaseBulletEntity
extends Projectile {
    @Nullable
    private Entity finalTarget;
    @Nullable
    private Direction currentMoveDirection;
    private int flightSteps;
    private double targetDeltaX;
    private double targetDeltaY;
    private double targetDeltaZ;
    @Nullable
    private UUID targetId;

    public BaseBulletEntity(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
        this.noPhysics = true;
    }

    public BaseBulletEntity(EntityType<? extends Projectile> type, Level level, LivingEntity livingEntity, @Nonnull Entity entity, Direction.Axis axis) {
        this(type, level);
        this.setOwner((Entity)livingEntity);
        BlockPos blockpos = livingEntity.blockPosition();
        double d0 = (double)blockpos.getX() + 0.5;
        double d1 = (double)blockpos.getY() + 0.5;
        double d2 = (double)blockpos.getZ() + 0.5;
        this.moveTo(d0, d1, d2, this.getYRot(), this.getXRot());
        this.finalTarget = entity;
        this.currentMoveDirection = Direction.UP;
        this.selectNextMoveDirection(axis);
    }

    @Nonnull
    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    protected void addAdditionalSaveData(@Nonnull CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        if (this.finalTarget != null) {
            pCompound.putUUID("Target", this.finalTarget.getUUID());
        }
        if (this.currentMoveDirection != null) {
            pCompound.putInt("Dir", this.currentMoveDirection.get3DDataValue());
        }
        pCompound.putInt("Steps", this.flightSteps);
        pCompound.putDouble("TXD", this.targetDeltaX);
        pCompound.putDouble("TYD", this.targetDeltaY);
        pCompound.putDouble("TZD", this.targetDeltaZ);
    }

    protected void readAdditionalSaveData(@Nonnull CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.flightSteps = pCompound.getInt("Steps");
        this.targetDeltaX = pCompound.getDouble("TXD");
        this.targetDeltaY = pCompound.getDouble("TYD");
        this.targetDeltaZ = pCompound.getDouble("TZD");
        if (pCompound.contains("Dir", 99)) {
            this.currentMoveDirection = Direction.from3DDataValue((int)pCompound.getInt("Dir"));
        }
        if (pCompound.hasUUID("Target")) {
            this.targetId = pCompound.getUUID("Target");
        }
    }

    @Nullable
    private Direction getMoveDirection() {
        return this.currentMoveDirection;
    }

    private void setMoveDirection(@Nullable Direction pDirection) {
        this.currentMoveDirection = pDirection;
    }

    private void selectNextMoveDirection(@Nullable Direction.Axis p_37349_) {
        BlockPos blockpos;
        double d0 = 0.5;
        if (this.finalTarget == null) {
            blockpos = this.blockPosition().below();
        } else {
            d0 = (double)this.finalTarget.getBbHeight() * 0.5;
            blockpos = new BlockPos(this.finalTarget.getBlockX(), (int)((double)this.finalTarget.getBlockY() + d0), this.finalTarget.getBlockZ());
        }
        double d1 = (double)blockpos.getX() + 0.5;
        double d2 = (double)blockpos.getY() + d0;
        double d3 = (double)blockpos.getZ() + 0.5;
        Direction direction = null;
        if (!this.closerToCenterThan(blockpos, (Position)this.position(), 2.0)) {
            BlockPos blockpos1 = this.blockPosition();
            ArrayList list = Lists.newArrayList();
            if (p_37349_ != Direction.Axis.X) {
                if (blockpos1.getX() < blockpos.getX() && this.level().isEmptyBlock(blockpos1.east())) {
                    list.add(Direction.EAST);
                } else if (blockpos1.getX() > blockpos.getX() && this.level().isEmptyBlock(blockpos1.west())) {
                    list.add(Direction.WEST);
                }
            }
            if (p_37349_ != Direction.Axis.Y) {
                if (blockpos1.getY() < blockpos.getY() && this.level().isEmptyBlock(blockpos1.above())) {
                    list.add(Direction.UP);
                } else if (blockpos1.getY() > blockpos.getY() && this.level().isEmptyBlock(blockpos1.below())) {
                    list.add(Direction.DOWN);
                }
            }
            if (p_37349_ != Direction.Axis.Z) {
                if (blockpos1.getZ() < blockpos.getZ() && this.level().isEmptyBlock(blockpos1.south())) {
                    list.add(Direction.SOUTH);
                } else if (blockpos1.getZ() > blockpos.getZ() && this.level().isEmptyBlock(blockpos1.north())) {
                    list.add(Direction.NORTH);
                }
            }
            direction = Direction.getRandom((RandomSource)this.random);
            if (list.isEmpty()) {
                for (int i = 5; !this.level().isEmptyBlock(blockpos1.relative(direction)) && i > 0; --i) {
                    direction = Direction.getRandom((RandomSource)this.random);
                }
            } else {
                direction = (Direction)list.get(this.random.nextInt(list.size()));
            }
            d1 = this.getX() + (double)direction.getStepX();
            d2 = this.getY() + (double)direction.getStepY();
            d3 = this.getZ() + (double)direction.getStepZ();
        }
        this.setMoveDirection(direction);
        double d6 = d1 - this.getX();
        double d7 = d2 - this.getY();
        double d4 = d3 - this.getZ();
        double d5 = Math.sqrt(d6 * d6 + d7 * d7 + d4 * d4);
        if (d5 == 0.0) {
            this.targetDeltaX = 0.0;
            this.targetDeltaY = 0.0;
            this.targetDeltaZ = 0.0;
        } else {
            this.targetDeltaX = d6 / d5 * 0.15;
            this.targetDeltaY = d7 / d5 * 0.15;
            this.targetDeltaZ = d4 / d5 * 0.15;
        }
        this.hasImpulse = true;
        this.flightSteps = 10 + this.random.nextInt(5) * 10;
    }

    private boolean closerToCenterThan(BlockPos pos, Position position, double distance) {
        return this.distToCenterSqr(pos, position.x(), position.y(), position.z()) < Mth.square((double)distance);
    }

    private double distToCenterSqr(BlockPos pos, double x, double y, double z) {
        double d0 = (double)pos.getX() + 0.5 - x;
        double d1 = (double)pos.getY() + 0.5 - y;
        double d2 = (double)pos.getZ() + 0.5 - z;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void checkDespawn() {
        if (this.level().getDifficulty() == Difficulty.PEACEFUL) {
            this.discard();
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            HitResult hitresult;
            if (this.finalTarget == null && this.targetId != null) {
                this.finalTarget = ((ServerLevel)this.level()).getEntity(this.targetId);
                if (this.finalTarget == null) {
                    this.targetId = null;
                }
            }
            if (this.finalTarget == null || !this.finalTarget.isAlive() || this.finalTarget instanceof Player && this.finalTarget.isSpectator()) {
                if (!this.isNoGravity()) {
                    this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
                }
            } else {
                this.targetDeltaX = Mth.clamp((double)(this.targetDeltaX * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaY = Mth.clamp((double)(this.targetDeltaY * 1.025), (double)-1.0, (double)1.0);
                this.targetDeltaZ = Mth.clamp((double)(this.targetDeltaZ * 1.025), (double)-1.0, (double)1.0);
                Vec3 vec3 = this.getDeltaMovement();
                this.setDeltaMovement(vec3.add((this.targetDeltaX - vec3.x) * 0.2, (this.targetDeltaY - vec3.y) * 0.2, (this.targetDeltaZ - vec3.z) * 0.2));
            }
            if ((hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity)).getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.onHit(hitresult);
            }
        }
        this.checkInsideBlocks();
        Vec3 vec31 = this.getDeltaMovement();
        this.setPos(this.getX() + vec31.x, this.getY() + vec31.y, this.getZ() + vec31.z);
        ProjectileUtil.rotateTowardsMovement((Entity)this, (float)0.5f);
        if (this.level().isClientSide) {
            this.level().addParticle(this.getParticle(), this.getX() - vec31.x, this.getY() - vec31.y + 0.15, this.getZ() - vec31.z, 0.0, 0.0, 0.0);
        } else if (this.finalTarget != null && !this.finalTarget.isRemoved()) {
            if (this.flightSteps > 0) {
                --this.flightSteps;
                if (this.flightSteps == 0) {
                    this.selectNextMoveDirection(this.currentMoveDirection == null ? null : this.currentMoveDirection.getAxis());
                }
            }
            if (this.currentMoveDirection != null) {
                BlockPos blockpos = this.blockPosition();
                Direction.Axis direction$axis = this.currentMoveDirection.getAxis();
                if (this.level().loadedAndEntityCanStandOn(blockpos.relative(this.currentMoveDirection), (Entity)this)) {
                    this.selectNextMoveDirection(direction$axis);
                } else {
                    BlockPos blockpos1 = this.finalTarget.blockPosition();
                    if (direction$axis == Direction.Axis.X && blockpos.getX() == blockpos1.getX() || direction$axis == Direction.Axis.Z && blockpos.getZ() == blockpos1.getZ() || direction$axis == Direction.Axis.Y && blockpos.getY() == blockpos1.getY()) {
                        this.selectNextMoveDirection(direction$axis);
                    }
                }
            }
        }
    }

    protected boolean canHitEntity(@Nonnull Entity pTarget) {
        return super.canHitEntity(pTarget) && !pTarget.noPhysics;
    }

    public boolean isOnFire() {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        return pDistance < 16384.0;
    }

    public float getBrightness() {
        return 1.0f;
    }

    protected void onHitEntity(@Nonnull EntityHitResult pResult) {
        super.onHitEntity(pResult);
        Entity entity = pResult.getEntity();
        if (entity != this.getOwner() && entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            this.bulletEffect(target);
        }
    }

    protected void onHitBlock(@Nonnull BlockHitResult hitResult) {
        super.onHitBlock(hitResult);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY(), this.getZ(), 2, 0.2, 0.2, 0.2, 0.0);
            this.playSound(SoundEvents.SHULKER_BULLET_HIT, 1.0f, 1.0f);
        }
    }

    protected void onHit(@Nonnull HitResult pResult) {
        super.onHit(pResult);
        this.discard();
    }

    public boolean isPickable() {
        return true;
    }

    public boolean hurt(@Nonnull DamageSource pSource, float pAmount) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.playSound(SoundEvents.SHULKER_BULLET_HURT, 1.0f, 1.0f);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.CRIT, this.getX(), this.getY(), this.getZ(), 15, 0.2, 0.2, 0.2, 0.0);
            this.discard();
        }
        return true;
    }

    public void recreateFromPacket(@Nonnull ClientboundAddEntityPacket pPacket) {
        super.recreateFromPacket(pPacket);
        double d0 = pPacket.getXa();
        double d1 = pPacket.getYa();
        double d2 = pPacket.getZa();
        this.setDeltaMovement(d0, d1, d2);
    }

    protected abstract void bulletEffect(LivingEntity var1);

    protected abstract ParticleOptions getParticle();
}

