/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.capability;

import java.util.stream.Collectors;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingConversionEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.network.SPacketSyncChampion;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.util.ChampionBuilder;
import top.theillusivec4.champions.common.util.ChampionHelper;

public class AttachmentEventHandler {
    @SubscribeEvent
    public void onSpecialSpawn(MobSpawnEvent.PositionCheck evt) {
        Mob entity = evt.getEntity();
        if (!entity.level().isClientSide()) {
            ChampionAttachment.getAttachment((Entity)entity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                if (ChampionHelper.isValidChampion(serverChampion)) {
                    if (!ChampionsConfig.championSpawners && evt.getSpawner() != null) {
                        serverChampion.setRank(RankManager.getLowestRank());
                    } else {
                        ChampionBuilder.spawn(champion);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onLivingConvert(LivingConversionEvent.Post evt) {
        LivingEntity entity = evt.getEntity();
        if (!entity.level().isClientSide()) {
            LivingEntity outcome = evt.getOutcome();
            ChampionAttachment.getAttachment((Entity)entity).ifPresent(oldChampion -> {
                if (ChampionHelper.isValidChampion(oldChampion.getServer())) {
                    ChampionAttachment.getAttachment((Entity)outcome).ifPresent(newChampion -> {
                        ChampionBuilder.copy(oldChampion, newChampion);
                        IChampion.Server serverChampion = newChampion.getServer();
                        PacketDistributor.sendToPlayersTrackingEntity((Entity)outcome, (CustomPacketPayload)new SPacketSyncChampion(outcome.getId(), serverChampion.getRank().map(Rank::getTier).orElse(0), serverChampion.getRank().map(Rank::getDefaultColor).orElse(0), serverChampion.getAffixes().stream().map(IAffix::getIdentifier).collect(Collectors.toSet())), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    });
                }
            });
        }
    }

    @SubscribeEvent
    public void startTracking(PlayerEvent.StartTracking evt) {
        Entity entity = evt.getTarget();
        Player playerEntity = evt.getEntity();
        if (playerEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
            ChampionAttachment.getAttachment(entity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                if (ChampionHelper.isValidChampion(serverChampion)) {
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SPacketSyncChampion(entity.getId(), serverChampion.getRank().map(Rank::getTier).orElse(0), serverChampion.getRank().map(Rank::getDefaultColor).orElse(0), serverChampion.getAffixes().stream().map(IAffix::getIdentifier).collect(Collectors.toSet())), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            });
        }
    }
}

