/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix.core;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.AffixRegistry;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.network.SPacketSyncAffixData;

public abstract class BasicAffix
implements IAffix {
    private final AffixCategory category;

    public BasicAffix(AffixCategory category) {
        this(category, false);
    }

    public BasicAffix(AffixCategory category, boolean hasSubscriptions) {
        this.category = category;
        Champions.API.addCategory(category, this);
        if (hasSubscriptions) {
            NeoForge.EVENT_BUS.register((Object)this);
        }
    }

    public static boolean canTarget(LivingEntity livingEntity, LivingEntity target, boolean sightCheck) {
        if (target == null || !target.isAlive() || target instanceof ArmorStand || sightCheck && !BasicAffix.hasLineOfSight(livingEntity, target)) {
            return false;
        }
        AttributeInstance attributeInstance = livingEntity.getAttribute(Attributes.FOLLOW_RANGE);
        double range = attributeInstance == null ? 16.0 : attributeInstance.getValue();
        range = ChampionsConfig.affixTargetRange == 0.0 ? range : Math.min(range, ChampionsConfig.affixTargetRange);
        return (double)livingEntity.distanceTo((Entity)target) <= range;
    }

    private static boolean hasLineOfSight(LivingEntity livingEntity, LivingEntity target) {
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            return mob.getSensing().hasLineOfSight((Entity)target);
        }
        return livingEntity.hasLineOfSight((Entity)target);
    }

    @Override
    public ResourceLocation getIdentifier() {
        return AffixRegistry.AFFIX_REGISTRY.getKey((Object)this);
    }

    public String toString() {
        return this.getIdentifier().toString();
    }

    @Override
    public AffixCategory getCategory() {
        return this.category;
    }

    @Override
    public void sync(IChampion champion) {
        LivingEntity livingEntity = champion.getLivingEntity();
        CompoundTag tag = this.writeSyncTag(champion);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)livingEntity, (CustomPacketPayload)new SPacketSyncAffixData(livingEntity.getId(), this.toString(), tag), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

