/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.registry.ModMobEffects;

public class WoundingAffix
extends BasicAffix {
    public WoundingAffix() {
        super(AffixCategory.OFFENSE, true);
    }

    @SubscribeEvent
    public void onHeal(LivingHealEvent evt) {
        if (evt.getEntity().hasEffect(ModMobEffects.WOUND_EFFECT_TYPE)) {
            evt.setAmount(evt.getAmount() * 0.5f);
        }
    }

    @SubscribeEvent
    public void onDamage(LivingDamageEvent.Pre evt) {
        if (evt.getEntity().hasEffect(ModMobEffects.WOUND_EFFECT_TYPE)) {
            evt.setNewDamage(evt.getOriginalDamage() * 1.5f);
        }
    }

    @Override
    public boolean onAttack(IChampion champion, LivingEntity target, DamageSource source, float amount) {
        if ((double)target.getRandom().nextFloat() < ChampionsConfig.woundingChance) {
            target.addEffect(new MobEffectInstance(ModMobEffects.WOUND_EFFECT_TYPE, 200, 0));
        }
        return true;
    }
}

