/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.registry.ModDamageTypes;

public class ReflectiveAffix
extends BasicAffix {
    public ReflectiveAffix() {
        super(AffixCategory.OFFENSE, true);
    }

    @SubscribeEvent
    public void onDamageEvent(LivingDamageEvent.Pre evt) {
        if (!ChampionsConfig.reflectiveLethal && evt.getSource().is(ModDamageTypes.REFLECTION_DAMAGE)) {
            LivingEntity living = evt.getEntity();
            float currentDamage = evt.getOriginalDamage();
            if (currentDamage >= living.getHealth()) {
                evt.setNewDamage(living.getHealth() - 1.0f);
            }
        }
    }

    @Override
    public float onDamage(IChampion champion, DamageSource source, float amount, float newAmount) {
        Entity entity = source.getDirectEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity sourceEntity = (LivingEntity)entity;
            if (source.is(ModDamageTypes.REFLECTION_DAMAGE) || source.is(DamageTypes.THORNS)) {
                return newAmount;
            }
            DamageSource newSource = ModDamageTypes.of(ModDamageTypes.REFLECTION_DAMAGE, (Entity)champion.getLivingEntity());
            if (source.getEntity() != null) {
                newSource = ModDamageTypes.of(ModDamageTypes.REFLECTION_DAMAGE, source.getDirectEntity(), (Entity)champion.getLivingEntity());
            }
            float min = (float)ChampionsConfig.reflectiveMinPercent;
            if (source.is(DamageTypeTags.IS_FIRE) || source.is(DamageTypeTags.IS_PROJECTILE) || source.is(DamageTypeTags.IS_EXPLOSION) || source.is(DamageTypeTags.DAMAGES_HELMET) || source.is(DamageTypes.MAGIC) || source.is(DamageTypeTags.BYPASSES_ARMOR) || source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
                newSource = new DamageSource(source.typeHolder(), (Entity)sourceEntity, (Entity)champion.getLivingEntity());
            }
            float damage = (float)Math.min((double)amount * ((double)sourceEntity.getRandom().nextFloat() * (ChampionsConfig.reflectiveMaxPercent - (double)min) + (double)min), (double)ChampionsConfig.reflectiveMax);
            sourceEntity.hurt(newSource, damage);
        }
        return newAmount;
    }
}

