/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import java.util.Collections;
import java.util.List;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.affix.core.GoalAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;

public class MagneticAffix
extends GoalAffix {
    public MagneticAffix() {
        super(AffixCategory.CC);
    }

    @Override
    public List<Tuple<Integer, Goal>> getGoals(IChampion champion) {
        return Collections.singletonList(new Tuple((Object)0, (Object)new PullGoal((Mob)champion.getLivingEntity())));
    }

    public static class PullGoal
    extends Goal {
        final Mob mobEntity;
        LivingEntity target = null;

        public PullGoal(Mob mobEntity) {
            this.mobEntity = mobEntity;
        }

        public void start() {
            this.target = this.mobEntity.getTarget();
            super.start();
        }

        public void stop() {
            this.target = null;
            super.stop();
        }

        public boolean canUse() {
            return this.mobEntity.getTarget() != null && BasicAffix.canTarget((LivingEntity)this.mobEntity, this.mobEntity.getTarget(), true) && this.mobEntity.tickCount % 40 == 0 && this.mobEntity.getRandom().nextDouble() < 0.4;
        }

        public boolean canContinueToUse() {
            return this.mobEntity.tickCount % 40 != 0 || this.mobEntity.getRandom().nextDouble() > 0.7;
        }

        public void tick() {
            double x = this.mobEntity.position().x;
            double y = this.mobEntity.position().y;
            double z = this.mobEntity.position().z;
            double strength = ChampionsConfig.magneticStrength;
            Vec3 vec = new Vec3(x, y, z).subtract(new Vec3(this.target.position().x, this.target.position().y, this.target.position().z)).normalize().scale(strength);
            this.target.setDeltaMovement(vec);
            if (this.target instanceof Player) {
                this.target.hurtMarked = true;
            }
        }
    }
}

