/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import java.util.Collections;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Tuple;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.affix.core.GoalAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.entity.EnkindlingBulletEntity;

public class EnkindlingAffix
extends GoalAffix {
    public EnkindlingAffix() {
        super(AffixCategory.OFFENSE);
    }

    @Override
    public List<Tuple<Integer, Goal>> getGoals(IChampion champion) {
        return Collections.singletonList(new Tuple((Object)0, (Object)new AttackGoal((Mob)champion.getLivingEntity())));
    }

    static class AttackGoal
    extends Goal {
        private final Mob mobEntity;
        private int attackTime;

        public AttackGoal(Mob mobEntity) {
            this.mobEntity = mobEntity;
        }

        public boolean canUse() {
            LivingEntity livingentity = this.mobEntity.getTarget();
            if (livingentity != null && livingentity.isAlive()) {
                return BasicAffix.canTarget((LivingEntity)this.mobEntity, livingentity, true) && this.mobEntity.level().getDifficulty() != Difficulty.PEACEFUL;
            }
            return false;
        }

        public void start() {
            this.attackTime = ChampionsConfig.enkindlingAttackInterval * 20;
        }

        public void tick() {
            if (this.mobEntity.level().getDifficulty() != Difficulty.PEACEFUL) {
                --this.attackTime;
                LivingEntity livingentity = this.mobEntity.getTarget();
                if (livingentity != null) {
                    this.mobEntity.getLookControl().setLookAt((Entity)livingentity, 180.0f, 180.0f);
                    double sqrDistance = this.mobEntity.distanceToSqr((Entity)livingentity);
                    if (sqrDistance < 400.0) {
                        if (this.attackTime <= 0) {
                            this.attackTime = ChampionsConfig.enkindlingAttackInterval * 20 + this.mobEntity.getRandom().nextInt(10) * 20 / 2;
                            this.mobEntity.level().addFreshEntity((Entity)new EnkindlingBulletEntity(this.mobEntity.level(), (LivingEntity)this.mobEntity, (Entity)livingentity, this.mobEntity.getMotionDirection().getAxis()));
                            this.mobEntity.playSound(SoundEvents.SHULKER_SHOOT, 2.0f, (this.mobEntity.getRandom().nextFloat() - this.mobEntity.getRandom().nextFloat()) * 0.2f + 1.0f);
                        }
                    } else {
                        this.mobEntity.setTarget(null);
                    }
                }
                super.tick();
            }
        }
    }
}

