/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common.affix;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import top.theillusivec4.champions.api.AffixCategory;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.common.affix.core.AffixData;
import top.theillusivec4.champions.common.affix.core.BasicAffix;
import top.theillusivec4.champions.common.config.ChampionsConfig;

public class AdaptableAffix
extends BasicAffix {
    public AdaptableAffix() {
        super(AffixCategory.DEFENSE);
    }

    @Override
    public float onHurt(IChampion champion, DamageSource source, float amount, float newAmount) {
        String type = source.getMsgId();
        DamageData damageData = AffixData.getData(champion, this.getIdentifier().getPath(), DamageData.class);
        if (damageData.name.equalsIgnoreCase(type)) {
            newAmount -= (float)((double)amount * ChampionsConfig.adaptableDamageReductionIncrement * (double)damageData.count);
            ++damageData.count;
        } else {
            damageData.name = type;
            damageData.count = 0;
        }
        damageData.saveData();
        return Math.max(amount * (float)(1.0 - ChampionsConfig.adaptableMaxDamageReduction), newAmount);
    }

    public static class DamageData
    extends AffixData {
        String name;
        int count;

        @Override
        public void readFromNBT(CompoundTag tag) {
            this.name = tag.getString("name");
            this.count = tag.getInt("count");
        }

        @Override
        public CompoundTag writeToNBT() {
            CompoundTag compound = new CompoundTag();
            compound.putString("name", this.name);
            compound.putInt("count", this.count);
            return compound;
        }
    }
}

