/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.common;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.FastColor;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.client.ChampionsOverlay;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.rank.Rank;
import top.theillusivec4.champions.common.registry.ModParticleTypes;
import top.theillusivec4.champions.common.registry.ModStats;
import top.theillusivec4.champions.common.util.ChampionBuilder;
import top.theillusivec4.champions.common.util.ChampionHelper;
import top.theillusivec4.champions.server.command.ChampionsCommand;

public class ChampionEventsHandler {
    @SubscribeEvent
    public void onLivingXpDrop(LivingExperienceDropEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        ChampionAttachment.getAttachment((Entity)livingEntity).flatMap(champion -> champion.getServer().getRank()).ifPresent(rank -> {
            int growth = rank.getGrowthFactor();
            if (growth > 0) {
                evt.setDroppedExperience(growth * ChampionsConfig.experienceGrowth * evt.getOriginalExperience() + evt.getDroppedExperience());
            }
        });
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Start evt) {
        Explosion explosion = evt.getExplosion();
        Entity entity = explosion.getDirectSourceEntity();
        if (entity != null && !entity.level().isClientSide()) {
            ChampionAttachment.getAttachment(entity).flatMap(champion -> champion.getServer().getRank()).ifPresent(rank -> {
                int growth = rank.getGrowthFactor();
                if (growth > 0) {
                    explosion.radius += (float)(ChampionsConfig.explosionGrowth * growth);
                }
            });
        }
    }

    @SubscribeEvent
    public void onLivingJoinWorld(EntityJoinLevelEvent evt) {
        Entity entity = evt.getEntity();
        if (!entity.level().isClientSide()) {
            ChampionAttachment.getAttachment(entity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                Optional<Rank> maybeRank = serverChampion.getRank();
                if (maybeRank.isEmpty()) {
                    ChampionBuilder.spawn(champion);
                }
                serverChampion.getAffixes().forEach(affix -> affix.onSpawn((IChampion)champion));
                serverChampion.getRank().ifPresent(rank -> {
                    List<Tuple<Holder<MobEffect>, Integer>> effects = rank.getEffects();
                    effects.forEach(effectPair -> champion.getLivingEntity().addEffect(new MobEffectInstance((Holder)effectPair.getA(), 200, ((Integer)effectPair.getB()).intValue())));
                });
            });
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(EntityTickEvent.Pre evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.level().isClientSide()) {
                ChampionAttachment.getAttachment((Entity)livingEntity).ifPresent(champion -> {
                    IChampion.Client clientChampion = champion.getClient();
                    if (ChampionHelper.isValidChampion(clientChampion)) {
                        clientChampion.getAffixes().forEach(affix -> affix.onClientUpdate((IChampion)champion));
                        clientChampion.getRank().ifPresent(rank -> {
                            if (ChampionsConfig.showParticles && (Integer)rank.getA() > 0) {
                                int color = (Integer)rank.getB();
                                float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
                                float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
                                float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
                                livingEntity.level().addParticle((ParticleOptions)ModParticleTypes.RANK_PARTICLE_TYPE.get(), livingEntity.position().x + (livingEntity.getRandom().nextDouble() - 0.5) * (double)livingEntity.getBbWidth(), livingEntity.position().y + livingEntity.getRandom().nextDouble() * (double)livingEntity.getBbHeight(), livingEntity.position().z + (livingEntity.getRandom().nextDouble() - 0.5) * (double)livingEntity.getBbWidth(), (double)r, (double)g, (double)b);
                            }
                        });
                    }
                });
            } else if (livingEntity.tickCount % 10 == 0) {
                ChampionAttachment.getAttachment((Entity)livingEntity).ifPresent(champion -> {
                    IChampion.Server serverChampion = champion.getServer();
                    if (ChampionHelper.isValidChampion(serverChampion)) {
                        serverChampion.getAffixes().forEach(affix -> affix.onServerUpdate((IChampion)champion));
                        serverChampion.getRank().ifPresent(rank -> {
                            if (livingEntity.tickCount % 4 == 0) {
                                List<Tuple<Holder<MobEffect>, Integer>> effects = rank.getEffects();
                                effects.forEach(effectPair -> livingEntity.addEffect(new MobEffectInstance((Holder)effectPair.getA(), 100, ((Integer)effectPair.getB()).intValue())));
                            }
                        });
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingIncomingDamageEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (!livingEntity.level().isClientSide()) {
            ChampionAttachment.getAttachment((Entity)livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                if (ChampionHelper.isValidChampion(serverChampion)) {
                    serverChampion.getAffixes().forEach(affix -> {
                        if (!affix.onAttacked((IChampion)champion, evt.getSource(), evt.getAmount())) {
                            evt.setCanceled(true);
                        }
                    });
                }
            });
            if (evt.isCanceled()) {
                return;
            }
            Entity source = evt.getSource().getDirectEntity();
            ChampionAttachment.getAttachment(source).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                if (ChampionHelper.isValidChampion(serverChampion)) {
                    serverChampion.getAffixes().forEach(affix -> {
                        if (!affix.onAttack((IChampion)champion, evt.getEntity(), evt.getSource(), evt.getAmount())) {
                            evt.setCanceled(true);
                        }
                    });
                }
            });
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent.Pre evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (!livingEntity.level().isClientSide()) {
            float[] amounts = new float[]{evt.getOriginalDamage(), evt.getNewDamage()};
            ChampionAttachment.getAttachment((Entity)livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                if (ChampionHelper.isValidChampion(serverChampion)) {
                    serverChampion.getAffixes().forEach(affix -> {
                        amounts[1] = affix.onDamage((IChampion)champion, evt.getSource(), amounts[0], amounts[1]);
                    });
                    serverChampion.getAffixes().forEach(affix -> {
                        amounts[1] = affix.onHurt((IChampion)champion, evt.getSource(), amounts[0], amounts[1]);
                    });
                    evt.setNewDamage(amounts[1]);
                }
            });
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (livingEntity.level().isClientSide()) {
            return;
        }
        ChampionAttachment.getAttachment((Entity)livingEntity).ifPresent(champion -> {
            IChampion.Server serverChampion = champion.getServer();
            if (ChampionHelper.isValidChampion(serverChampion)) {
                serverChampion.getAffixes().forEach(affix -> {
                    if (!affix.onDeath((IChampion)champion, evt.getSource())) {
                        evt.setCanceled(true);
                    }
                });
                serverChampion.getRank().ifPresent(rank -> {
                    Entity source;
                    if (!evt.isCanceled() && (source = evt.getSource().getEntity()) instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)source;
                        if (!(source instanceof FakePlayer)) {
                            MinecraftServer server;
                            player.awardStat((ResourceLocation)ModStats.CHAMPION_MOBS_KILLED.get());
                            int messageTier = ChampionsConfig.deathMessageTier;
                            if (messageTier > 0 && rank.getTier() >= messageTier && (server = livingEntity.getServer()) != null) {
                                server.getPlayerList().broadcastSystemMessage((Component)Component.translatable((String)("rank.champions.title." + rank.getTier())).append(" ").append(livingEntity.getCombatTracker().getDeathMessage()), false);
                            }
                        }
                    }
                });
            }
        });
    }

    @SubscribeEvent
    public void onServerStart(ServerAboutToStartEvent evt) {
        ChampionHelper.setServer(evt.getServer());
    }

    @SubscribeEvent
    public void onServerClose(ServerStoppedEvent evt) {
        ChampionHelper.setServer(null);
        ChampionHelper.clearBeacons();
    }

    @SubscribeEvent
    public void onLivingHeal(LivingHealEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (!livingEntity.level().isClientSide()) {
            float[] amounts = new float[]{evt.getAmount(), evt.getAmount()};
            ChampionAttachment.getAttachment((Entity)livingEntity).ifPresent(champion -> {
                IChampion.Server serverChampion = champion.getServer();
                if (ChampionHelper.isValidChampion(serverChampion)) {
                    serverChampion.getAffixes().forEach(affix -> {
                        amounts[1] = affix.onHeal((IChampion)champion, amounts[0], amounts[1]);
                    });
                }
            });
            evt.setAmount(amounts[1]);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    public void onBossBarEvent(CustomizeGuiOverlayEvent.BossEventProgress event) {
        event.setCanceled(ChampionsOverlay.isRendering);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @OnlyIn(value=Dist.CLIENT)
    public void onPressPickEgg(InputEvent.InteractionKeyMappingTriggered event) {
        if (event.isPickBlock()) {
            Entity pickedEntity = Minecraft.getInstance().crosshairPickEntity;
            LocalPlayer player = Minecraft.getInstance().player;
            ChampionAttachment.getAttachment(pickedEntity).ifPresent(champion -> {
                IChampion.Client clientChampion = champion.getClient();
                if (player != null && player.isCreative() && ChampionHelper.isValidChampion(clientChampion)) {
                    ChampionsCommand.createEgg((Player)player, champion.getLivingEntity().getType(), (int)clientChampion.getRank().map(Tuple::getA).orElseThrow(), clientChampion.getAffixes());
                }
            });
        }
    }
}

