/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.api.IAffix;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.client.ChampionsOverlay;
import top.theillusivec4.champions.client.config.ClientChampionsConfig;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.util.ChampionHelper;

public class HUDHelper {
    private static final ResourceLocation GUI_BAR_TEXTURES = Champions.getLocation("textures/gui/bars.png");
    private static final ResourceLocation GUI_STAR = Champions.getLocation("textures/gui/staricon.png");

    public static boolean renderHealthBar(GuiGraphics guiGraphics, LivingEntity livingEntity) {
        return ChampionAttachment.getAttachment((Entity)livingEntity).map(champion -> {
            IChampion.Client clientChampion = champion.getClient();
            return ChampionHelper.isValidChampion(clientChampion) && clientChampion.getRank().map(rank -> {
                int championLevel = (Integer)rank.getA();
                Set affixSet = clientChampion.getAffixes().stream().map(IAffix::getIdentifier).map(ResourceLocation::getPath).collect(Collectors.toSet());
                if (championLevel > 0 || !affixSet.isEmpty()) {
                    Object name;
                    Minecraft client = Minecraft.getInstance();
                    int i = client.getWindow().getGuiScaledWidth();
                    int k = i / 2 - 91;
                    int j = 21;
                    int xOffset = ClientChampionsConfig.hudXOffset;
                    int yOffset = ClientChampionsConfig.hudYOffset;
                    int color = (Integer)rank.getB();
                    float r = (float)FastColor.ARGB32.red((int)color) / 255.0f;
                    float g = (float)FastColor.ARGB32.green((int)color) / 255.0f;
                    float b = (float)FastColor.ARGB32.blue((int)color) / 255.0f;
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
                    RenderSystem.enableBlend();
                    ChampionsOverlay.startX = xOffset + k;
                    ChampionsOverlay.startY = yOffset + 1;
                    guiGraphics.blit(GUI_BAR_TEXTURES, xOffset + k, yOffset + j, 0.0f, 60.0f, 182, 5, 256, 256);
                    int healthOffset = (int)(livingEntity.getHealth() / livingEntity.getMaxHealth() * 183.0f);
                    if (healthOffset > 0) {
                        guiGraphics.blit(GUI_BAR_TEXTURES, xOffset + k, yOffset + j, 0.0f, 65.0f, healthOffset, 5, 256, 256);
                    }
                    if (championLevel <= 18) {
                        startStarsX = xOffset + i / 2 - 5 - 5 * (championLevel - 1);
                        for (int tier = 0; tier < championLevel; ++tier) {
                            guiGraphics.blit(GUI_STAR, startStarsX, yOffset + 1, 0.0f, 0.0f, 9, 9, 9, 9);
                            startStarsX += 10;
                        }
                    } else {
                        startStarsX = xOffset + i / 2 - 5;
                        String count = "x" + championLevel;
                        guiGraphics.blit(GUI_STAR, startStarsX - client.font.width(count) / 2, yOffset + 1, 0.0f, 0.0f, 9, 9, 9, 9);
                        guiGraphics.drawString(client.font, count, (float)(startStarsX + 10) - (float)client.font.width(count) / 2.0f, (float)(yOffset + 2), 0xFFFFFF, true);
                    }
                    Component customName = livingEntity.getCustomName();
                    if (customName == null) {
                        name = Component.translatable((String)("rank.champions.title." + championLevel)).getString();
                        name = (String)name + " " + livingEntity.getName().getString();
                    } else {
                        name = customName.getString();
                    }
                    guiGraphics.drawString(client.font, (String)name, (float)xOffset + (float)(i / 2 - client.font.width((String)name) / 2), (float)yOffset + (float)(j - 9), color, true);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    StringBuilder builder = new StringBuilder();
                    for (String affix : affixSet) {
                        builder.append(Component.translatable((String)("affix.champions." + affix)).getString());
                        builder.append(" ");
                    }
                    String affixes = builder.toString().trim();
                    guiGraphics.drawString(client.font, affixes, (float)xOffset + (float)(i / 2 - client.font.width(affixes) / 2), (float)yOffset + (float)(j + 6), 0xFFFFFF, true);
                    RenderSystem.disableBlend();
                    return true;
                }
                return false;
            }).orElse(false) != false;
        }).orElse(false);
    }
}

