/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ShulkerBulletModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import top.theillusivec4.champions.Champions;
import top.theillusivec4.champions.common.entity.BaseBulletEntity;

public class ColorizedBulletRenderer
extends EntityRenderer<BaseBulletEntity> {
    private static final ResourceLocation GENERIC_SPARK_TEXTURE = Champions.getLocation("textures/entity/generic_spark.png");
    private static final RenderType RENDER_TYPE = RenderType.entityTranslucent((ResourceLocation)GENERIC_SPARK_TEXTURE);
    private final ShulkerBulletModel<BaseBulletEntity> model;
    private final int color;

    public ColorizedBulletRenderer(EntityRendererProvider.Context manager, int color) {
        super(manager);
        this.color = color;
        this.model = new ShulkerBulletModel(manager.bakeLayer(ModelLayers.SHULKER_BULLET));
    }

    protected int getBlockLightLevel(@Nonnull BaseBulletEntity bullet, @Nonnull BlockPos blockPos) {
        return 15;
    }

    public void render(BaseBulletEntity entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        matrixStack.pushPose();
        float yRot = Mth.rotLerp((float)entity.yRotO, (float)entity.getYRot(), (float)partialTicks);
        float xRot = Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot());
        float tickModifier = (float)entity.tickCount + partialTicks;
        matrixStack.translate(0.0, (double)0.15f, 0.0);
        matrixStack.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(tickModifier * 0.1f)) * 180.0f));
        matrixStack.mulPose(Axis.XP.rotationDegrees(Mth.cos((float)(tickModifier * 0.1f)) * 180.0f));
        matrixStack.mulPose(Axis.ZP.rotationDegrees(Mth.sin((float)(tickModifier * 0.15f)) * 360.0f));
        matrixStack.scale(-0.5f, -0.5f, 0.5f);
        this.model.setupAnim((Entity)entity, 0.0f, 0.0f, 0.0f, yRot, xRot);
        VertexConsumer vertexconsumer = buffer.getBuffer(this.model.renderType(GENERIC_SPARK_TEXTURE));
        this.model.renderToBuffer(matrixStack, vertexconsumer, packedLight, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.color((int)255, (int)this.color));
        matrixStack.scale(1.5f, 1.5f, 1.5f);
        VertexConsumer vertexconsumer1 = buffer.getBuffer(RENDER_TYPE);
        this.model.renderToBuffer(matrixStack, vertexconsumer1, packedLight, OverlayTexture.NO_OVERLAY, FastColor.ARGB32.color((int)38, (int)this.color));
        matrixStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull BaseBulletEntity entity) {
        return GENERIC_SPARK_TEXTURE;
    }
}

