/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.champions.api.AffixRegistry;
import top.theillusivec4.champions.api.IChampionsApi;
import top.theillusivec4.champions.api.impl.ChampionsApiImpl;
import top.theillusivec4.champions.client.config.ClientChampionsConfig;
import top.theillusivec4.champions.common.affix.core.AffixManager;
import top.theillusivec4.champions.common.capability.ChampionAttachment;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.datagen.ModAdvancementProvider;
import top.theillusivec4.champions.common.datagen.ModDamageTypeTagsProvider;
import top.theillusivec4.champions.common.datagen.ModDatapackProvider;
import top.theillusivec4.champions.common.datagen.ModGlobalLootModifierProvider;
import top.theillusivec4.champions.common.integration.theoneprobe.TheOneProbePlugin;
import top.theillusivec4.champions.common.item.ChampionEggItem;
import top.theillusivec4.champions.common.network.SPacketSyncAffixData;
import top.theillusivec4.champions.common.network.SPacketSyncChampion;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.registry.ChampionsRegistry;
import top.theillusivec4.champions.common.registry.ModItems;
import top.theillusivec4.champions.common.registry.ModStats;
import top.theillusivec4.champions.common.util.ChampionHelper;
import top.theillusivec4.champions.common.util.EntityManager;
import top.theillusivec4.champions.server.command.ChampionSelectorOptions;
import top.theillusivec4.champions.server.command.ChampionsCommand;

@Mod(value="champions")
public class Champions {
    public static final String MODID = "champions";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final IChampionsApi API = ChampionsApiImpl.getInstance();
    public static boolean scalingHealthLoaded = false;
    public static boolean gameStagesLoaded = false;

    public Champions(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::registerNetwork);
        modEventBus.addListener(this::onGatherData);
        modEventBus.addListener(this::registerRegistries);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientChampionsConfig.CLIENT_SPEC);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ChampionsConfig.SERVER_SPEC);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ChampionsConfig.COMMON_SPEC);
        Champions.createServerConfig(ChampionsConfig.RANKS_SPEC, "ranks");
        Champions.createServerConfig(ChampionsConfig.AFFIXES_SPEC, "affixes");
        Champions.createServerConfig(ChampionsConfig.ENTITIES_SPEC, "entities");
        if (gameStagesLoaded) {
            modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ChampionsConfig.STAGE_SPEC, "champions-gamestages.toml");
        }
        modEventBus.addListener(this::config);
        modEventBus.addListener(this::setup);
        NeoForge.EVENT_BUS.addListener(this::registerCommands);
        ChampionsRegistry.register(modEventBus);
        scalingHealthLoaded = ModList.get().isLoaded("scalinghealth");
    }

    private static void createServerConfig(ModConfigSpec spec, String suffix) {
        String fileName = "champions-" + suffix + ".toml";
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)spec, fileName);
        File defaults = FMLPaths.GAMEDIR.get().resolve("defaultconfigs").resolve(fileName).toFile();
        if (!defaults.exists()) {
            try {
                FileUtils.copyInputStreamToFile((InputStream)Objects.requireNonNull(Champions.class.getClassLoader().getResourceAsStream(fileName)), (File)defaults);
            }
            catch (IOException e) {
                LOGGER.error("Error creating default config for " + fileName);
            }
        }
    }

    public static ResourceLocation getLocation(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private void registerRegistries(NewRegistryEvent event) {
        event.register(AffixRegistry.AFFIX_REGISTRY);
    }

    private void setup(FMLCommonSetupEvent evt) {
        ChampionAttachment.register();
        evt.enqueueWork(() -> {
            ModStats.registerFormatter();
            ChampionSelectorOptions.setup();
            DispenseItemBehavior dispenseBehavior = (source, stack) -> {
                Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
                Optional<EntityType<?>> entityType = ChampionEggItem.getType(stack);
                entityType.ifPresent(type -> {
                    Entity entity = type.create(source.level(), s -> stack.getTags(), source.pos().relative(direction), MobSpawnType.DISPENSER, true, direction != Direction.UP);
                    ChampionAttachment.getAttachment(entity).ifPresent(champion -> {
                        if (ChampionHelper.isValidChampion(champion.getServer())) {
                            ChampionEggItem.read(champion, stack);
                            source.level().addFreshEntity((Entity)champion.getLivingEntity());
                            stack.shrink(1);
                        }
                    });
                });
                return stack;
            };
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModItems.CHAMPION_EGG_ITEM.get()), (DispenseItemBehavior)dispenseBehavior);
        });
    }

    private void registerCommands(RegisterCommandsEvent evt) {
        ChampionsCommand.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void config(ModConfigEvent.Loading evt) {
        if (!evt.getConfig().getModId().equals(MODID)) {
            return;
        }
        if (evt.getConfig().getType() == ModConfig.Type.SERVER) {
            Champions champions = this;
            synchronized (champions) {
                IConfigSpec spec = evt.getConfig().getSpec();
                CommentedConfig commentedConfig = evt.getConfig().getLoadedConfig().config();
                ChampionsConfig.bake();
                if (spec == ChampionsConfig.RANKS_SPEC) {
                    ChampionsConfig.transformRanks(commentedConfig);
                    RankManager.buildRanks();
                } else if (spec == ChampionsConfig.AFFIXES_SPEC) {
                    ChampionsConfig.transformAffixes(commentedConfig);
                    AffixManager.buildAffixSettings();
                } else if (spec == ChampionsConfig.ENTITIES_SPEC) {
                    ChampionsConfig.transformEntities(commentedConfig);
                    EntityManager.buildEntitySettings();
                } else if (spec == ChampionsConfig.STAGE_SPEC && gameStagesLoaded) {
                    ChampionsConfig.entityStages = (List)ChampionsConfig.STAGE.entityStages.get();
                    ChampionsConfig.tierStages = (List)ChampionsConfig.STAGE.tierStages.get();
                }
            }
        } else if (evt.getConfig().getType() == ModConfig.Type.CLIENT) {
            ClientChampionsConfig.bake();
        } else if (evt.getConfig().getType() == ModConfig.Type.COMMON) {
            ChampionsConfig.bakeCommon();
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            LOGGER.info("Champions detected TheOneProbe, registering plugin now");
            InterModComms.sendTo((String)MODID, (String)"theoneprobe", (String)"getTheOneProbe", TheOneProbePlugin.GetTheOneProbe::new);
        }
    }

    private void registerNetwork(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        registrar.playToClient(SPacketSyncAffixData.TYPE, SPacketSyncAffixData.STREAM_CODEC, SPacketSyncAffixData::handle);
        registrar.playToClient(SPacketSyncChampion.TYPE, SPacketSyncChampion.STREAM_CODEC, SPacketSyncChampion::handle);
    }

    private void onGatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        ModDatapackProvider datapackProvider = (ModDatapackProvider)generator.addProvider(event.includeServer(), (DataProvider)new ModDatapackProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGlobalLootModifierProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModAdvancementProvider(packOutput, lookupProvider, existingFileHelper, List.of(new ModAdvancementProvider.Generator())));
        generator.addProvider(event.includeServer(), (DataProvider)new ModDamageTypeTagsProvider(packOutput, datapackProvider.getRegistryProvider(), existingFileHelper));
    }
}

