/*
 * Decompiled with CFR 0.152.
 */
package com.dragonfight.event;

import com.dragonfight.DragonfightMod;
import com.dragonfight.config.CommonConfiguration;
import com.dragonfight.fight.DragonFightManagerCustom;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class EventHandler {
    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Post event) {
        if (!event.getLevel().isClientSide && event.getLevel().dimension() == Level.END) {
            DragonFightManagerCustom.onWorldTick(event.getLevel());
        }
    }

    @SubscribeEvent
    public static void onEnterWorld(EntityJoinLevelEvent event) {
        if (event.getEntity() instanceof EnderDragon) {
            float pct = ((EnderDragon)event.getEntity()).getHealth() / ((EnderDragon)event.getEntity()).getMaxHealth();
            ((EnderDragon)event.getEntity()).getAttribute(Attributes.MAX_HEALTH).setBaseValue((double)Math.max((float)(400 + 50 * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).dragonDifficulty), ((EnderDragon)event.getEntity()).getMaxHealth()));
            ((EnderDragon)event.getEntity()).setHealth(((EnderDragon)event.getEntity()).getMaxHealth() * pct);
        }
    }

    @SubscribeEvent
    public static void onLivingSpawn(FinalizeSpawnEvent event) {
        if (event.getLevel() instanceof ServerLevel && ((ServerLevel)event.getLevel()).dimension() == Level.END && DragonFightManagerCustom.isFightRunning && BlockPos.ZERO.distToCenterSqr(event.getX(), 64.0, event.getZ()) < 90000.0) {
            event.setSpawnCancelled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerTick(PlayerTickEvent.Post playerTickEvent) {
        Integer flyTime = DragonFightManagerCustom.flyingPlayers.get(playerTickEvent.getEntity().getUUID());
        if (flyTime != null && !playerTickEvent.getEntity().isCreative()) {
            playerTickEvent.getEntity().getAbilities().flying = false;
        }
    }

    @SubscribeEvent
    public static void onExpDrop(LivingExperienceDropEvent event) {
        if (event.getEntity() instanceof EnderDragon) {
            event.setDroppedExperience((int)((double)event.getDroppedExperience() * ((CommonConfiguration)DragonfightMod.config.getCommonConfig()).dragonXPModifier));
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingDamageEvent.Pre event) {
        if (event.getSource().getEntity() instanceof EnderDragon) {
            event.setNewDamage(DragonFightManagerCustom.onAttackPlayer(event.getNewDamage()));
        }
    }
}

