/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.net;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamMessage;
import dev.ftb.mods.ftbteams.client.gui.MyTeamScreen;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManagerImpl;
import dev.ftb.mods.ftbteams.data.TeamMessageImpl;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record SyncMessageHistoryMessage(List<TeamMessage> messages) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncMessageHistoryMessage> TYPE = new CustomPacketPayload.Type(FTBTeamsAPI.rl("sync_msg_history"));
    public static StreamCodec<RegistryFriendlyByteBuf, SyncMessageHistoryMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)TeamMessageImpl.STREAM_CODEC.apply(ByteBufCodecs.list()), SyncMessageHistoryMessage::messages, SyncMessageHistoryMessage::new);

    public static SyncMessageHistoryMessage forTeam(Team team) {
        return new SyncMessageHistoryMessage(team.getMessageHistory());
    }

    public static void handle(SyncMessageHistoryMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ClientTeam team = ClientTeamManagerImpl.getInstance().selfTeam();
            if (team != null) {
                team.setMessageHistory(message.messages);
                MyTeamScreen.refreshIfOpen();
            }
        });
    }

    public CustomPacketPayload.Type<SyncMessageHistoryMessage> type() {
        return TYPE;
    }
}

