/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.net;

import com.mojang.authlib.GameProfile;
import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbteams.FTBTeamsAPIImpl;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;

public record CreatePartyMessage(String name, String description, int color, Set<GameProfile> invited) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<CreatePartyMessage> TYPE = new CustomPacketPayload.Type(FTBTeamsAPI.rl("create_party"));
    public static StreamCodec<FriendlyByteBuf, CreatePartyMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, CreatePartyMessage::name, (StreamCodec)ByteBufCodecs.STRING_UTF8, CreatePartyMessage::description, (StreamCodec)ByteBufCodecs.INT, CreatePartyMessage::color, (StreamCodec)ByteBufCodecs.GAME_PROFILE.apply(ByteBufCodecs.list()).map(Set::copyOf, List::copyOf), CreatePartyMessage::invited, CreatePartyMessage::new);

    public static void handle(CreatePartyMessage message, NetworkManager.PacketContext context) {
        context.queue(() -> {
            ServerPlayer player = (ServerPlayer)context.getPlayer();
            FTBTeamsAPI.api().getManager().getTeamForPlayer(player).ifPresent(team -> {
                if (FTBTeamsAPIImpl.INSTANCE.isPartyCreationFromAPIOnly()) {
                    player.displayClientMessage((Component)Component.translatable((String)"ftbteams.party_api_only").withStyle(ChatFormatting.RED), false);
                } else if (team instanceof PlayerTeam) {
                    PlayerTeam playerTeam = (PlayerTeam)team;
                    playerTeam.createParty(player.getUUID(), player, message.name, message.description, message.color, message.invited);
                }
            });
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

