/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.event.PlayerTransferredTeamOwnershipEvent;
import dev.ftb.mods.ftbteams.api.event.TeamAllyEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.data.AbstractTeam;
import dev.ftb.mods.ftbteams.data.FTBTUtils;
import dev.ftb.mods.ftbteams.data.PlayerTeam;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamManagerImpl;
import dev.ftb.mods.ftbteams.data.TeamType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;

public class PartyTeam
extends AbstractTeam {
    UUID owner = Util.NIL_UUID;

    public PartyTeam(TeamManagerImpl manager, UUID id) {
        super(manager, id);
    }

    @Override
    public TeamType getType() {
        return TeamType.PARTY;
    }

    @Override
    protected void serializeExtraNBT(CompoundTag tag) {
        tag.putString("owner", this.owner.toString());
    }

    @Override
    public void deserializeNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.deserializeNBT(tag, provider);
        this.owner = UUID.fromString(tag.getString("owner"));
    }

    @Override
    public TeamRank getRankForPlayer(UUID playerId) {
        return this.owner.equals(playerId) ? TeamRank.OWNER : super.getRankForPlayer(playerId);
    }

    public boolean isOwner(UUID profile) {
        return this.owner.equals(profile);
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public boolean isPartyTeam() {
        return true;
    }

    public int join(ServerPlayer player) throws CommandSyntaxException {
        Team oldTeam = this.manager.getTeamForPlayer(player).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)player.getUUID()));
        if (!(oldTeam instanceof PlayerTeam)) {
            throw TeamArgument.ALREADY_IN_PARTY.create();
        }
        PlayerTeam playerTeam = (PlayerTeam)oldTeam;
        UUID id = player.getUUID();
        playerTeam.setEffectiveTeam(this);
        this.ranks.put(id, TeamRank.MEMBER);
        this.sendMessage(Util.NIL_UUID, (Component)Component.translatable((String)"ftbteams.message.joined", (Object[])new Object[]{player.getName()}).withStyle(ChatFormatting.GREEN));
        this.markDirty();
        playerTeam.ranks.remove(id);
        playerTeam.markDirty();
        playerTeam.updatePresence();
        this.manager.syncToAll(this, oldTeam);
        this.onPlayerChangeTeam(oldTeam, id, player, false);
        return 1;
    }

    public int invite(ServerPlayer inviter, Collection<GameProfile> profiles) throws CommandSyntaxException {
        if (!FTBTUtils.canPlayerUseCommand(inviter, "ftbteams.party.invite")) {
            throw TeamArgument.NO_PERMISSION.create();
        }
        for (GameProfile profile : profiles) {
            FTBTeamsAPI.api().getManager().getTeamForPlayerID(profile.getId()).ifPresent(team -> {
                if (!(team instanceof PartyTeam)) {
                    this.ranks.put(profile.getId(), TeamRank.INVITED);
                    this.markDirty();
                    this.sendMessage(inviter.getUUID(), (Component)Component.translatable((String)"ftbteams.message.invited", (Object[])new Object[]{Component.literal((String)profile.getName()).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GREEN));
                    ServerPlayer invitee = FTBTUtils.getPlayerByUUID(this.manager.getServer(), profile.getId());
                    if (invitee != null && !invitee.getUUID().equals(inviter.getUUID())) {
                        invitee.displayClientMessage((Component)Component.translatable((String)"ftbteams.message.invite_sent", (Object[])new Object[]{inviter.getName().copy().withStyle(ChatFormatting.YELLOW)}), false);
                        Component acceptButton = this.makeInviteButton("ftbteams.accept", ChatFormatting.GREEN, "/ftbteams party join " + this.getShortName());
                        Component declineButton = this.makeInviteButton("ftbteams.decline", ChatFormatting.RED, "/ftbteams party decline " + this.getShortName());
                        invitee.displayClientMessage((Component)Component.literal((String)"[").append(acceptButton).append("] [").append(declineButton).append("]"), false);
                    }
                }
            });
        }
        return 1;
    }

    private Component makeInviteButton(String xlate, ChatFormatting color, String command) {
        return Component.translatable((String)xlate).withStyle(Style.EMPTY.withColor(color).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command)));
    }

    public int kick(CommandSourceStack from, Collection<GameProfile> players) throws CommandSyntaxException {
        for (GameProfile player : players) {
            UUID id = player.getId();
            Team oldTeam = this.manager.getTeamForPlayerID(id).orElseThrow(() -> ((SimpleCommandExceptionType)TeamArgument.NOT_IN_PARTY).create());
            if (oldTeam != this) {
                throw TeamArgument.NOT_IN_PARTY.create();
            }
            if (this.isOwner(id)) {
                throw TeamArgument.CANT_KICK_OWNER.create();
            }
            PlayerTeam team = this.manager.getPersonalTeamForPlayerID(id);
            team.setEffectiveTeam(team);
            ServerPlayer playerToKick = FTBTUtils.getPlayerByUUID(this.manager.getServer(), id);
            team.ranks.put(id, TeamRank.OWNER);
            UUID fromId = from.getPlayer() != null ? from.getPlayer().getUUID() : Util.NIL_UUID;
            this.sendMessage(fromId, (Component)Component.translatable((String)"ftbteams.message.kicked", (Object[])new Object[]{this.manager.getPlayerName(id).copy().withStyle(ChatFormatting.YELLOW), this.getName()}).withStyle(ChatFormatting.GOLD));
            team.markDirty();
            this.ranks.remove(id);
            this.markDirty();
            team.updatePresence();
            this.manager.syncToAll(this, team);
            if (playerToKick != null) {
                playerToKick.displayClientMessage((Component)Component.translatable((String)"ftbteams.message.kicked", (Object[])new Object[]{playerToKick.getName().copy().withStyle(ChatFormatting.YELLOW), this.getName().copy().withStyle(ChatFormatting.AQUA)}), false);
                this.updateCommands(playerToKick);
            }
            team.onPlayerChangeTeam(this, id, playerToKick, false);
        }
        return 1;
    }

    public int promote(ServerPlayer from, Collection<GameProfile> players) throws CommandSyntaxException {
        boolean changesMade = false;
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (this.getRankForPlayer(id) == TeamRank.MEMBER) {
                this.ranks.put(id, TeamRank.OFFICER);
                MutableComponent playerName = this.manager.getPlayerName(id).copy().withStyle(ChatFormatting.YELLOW);
                this.sendMessage(from.getUUID(), (Component)Component.translatable((String)"ftbteams.message.promoted", (Object[])new Object[]{playerName}).withStyle(ChatFormatting.GREEN));
                changesMade = true;
                continue;
            }
            throw TeamArgument.NOT_MEMBER.create((Object)this.manager.getPlayerName(id), (Object)this.getName());
        }
        if (changesMade) {
            this.markDirty();
            this.manager.syncToAll(this);
        }
        return 1;
    }

    public int demote(ServerPlayer from, Collection<GameProfile> players) throws CommandSyntaxException {
        boolean changesMade = false;
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (this.getRankForPlayer(id) == TeamRank.OFFICER) {
                this.ranks.put(id, TeamRank.MEMBER);
                MutableComponent playerName = this.manager.getPlayerName(id).copy().withStyle(ChatFormatting.YELLOW);
                this.sendMessage(from.getUUID(), (Component)Component.translatable((String)"ftbteams.message.demoted", (Object[])new Object[]{playerName}).withStyle(ChatFormatting.GOLD));
                changesMade = true;
                continue;
            }
            throw TeamArgument.NOT_OFFICER.create((Object)this.manager.getPlayerName(id), (Object)this.getName());
        }
        if (changesMade) {
            this.markDirty();
            this.manager.syncToAll(this);
        }
        return 1;
    }

    public int transferOwnership(CommandSourceStack from, Collection<GameProfile> toProfiles) throws CommandSyntaxException {
        return this.transferOwnership(from, toProfiles.stream().findFirst().orElseThrow());
    }

    public int transferOwnership(CommandSourceStack from, GameProfile toProfile) throws CommandSyntaxException {
        ServerPlayer toPlayer;
        UUID newOwnerID = toProfile.getId();
        if (!this.getMembers().contains(newOwnerID)) {
            throw TeamArgument.NOT_MEMBER.create((Object)toProfile.toString(), (Object)this.getName());
        }
        if (this.owner.equals(newOwnerID)) {
            from.sendSystemMessage((Component)Component.literal((String)"Already owner!").withStyle(ChatFormatting.RED));
            return 0;
        }
        this.ranks.put(this.owner, TeamRank.OFFICER);
        this.owner = newOwnerID;
        this.ranks.put(this.owner, TeamRank.OWNER);
        this.markDirty();
        ServerPlayer fromPlayer = from.getPlayer();
        if (fromPlayer != null) {
            this.updateCommands(fromPlayer);
        }
        if ((toPlayer = from.getServer().getPlayerList().getPlayer(newOwnerID)) != null) {
            ((Consumer)TeamEvent.OWNERSHIP_TRANSFERRED.invoker()).accept(new PlayerTransferredTeamOwnershipEvent((Team)this, fromPlayer, toPlayer));
            this.updateCommands(toPlayer);
        } else {
            ((Consumer)TeamEvent.OWNERSHIP_TRANSFERRED.invoker()).accept(new PlayerTransferredTeamOwnershipEvent(this, fromPlayer, toProfile));
        }
        UUID fromId = fromPlayer == null ? Util.NIL_UUID : fromPlayer.getUUID();
        MutableComponent msg = Component.translatable((String)"ftbteams.message.transfer_owner", (Object[])new Object[]{Component.literal((String)toProfile.getName()).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GREEN);
        this.sendMessage(fromId, (Component)msg);
        if (fromPlayer == null) {
            from.sendSystemMessage((Component)msg);
        }
        this.manager.syncToAll(this);
        return 1;
    }

    public int leave(UUID id) throws CommandSyntaxException {
        ServerPlayer player = FTBTeamsAPI.api().getManager().getServer().getPlayerList().getPlayer(id);
        if (this.isOwner(id) && this.getMembers().size() > 1) {
            throw TeamArgument.OWNER_CANT_LEAVE.create();
        }
        PlayerTeam playerTeam = this.manager.getPersonalTeamForPlayerID(id);
        playerTeam.setEffectiveTeam(playerTeam);
        playerTeam.ranks.put(id, TeamRank.OWNER);
        String playerName = player == null ? id.toString() : player.getGameProfile().getName();
        this.sendMessage(Util.NIL_UUID, (Component)Component.translatable((String)"ftbteams.message.left_party", (Object[])new Object[]{Component.literal((String)playerName).withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GOLD));
        playerTeam.markDirty();
        this.ranks.remove(id);
        this.manager.markDirty();
        boolean deletingTeam = false;
        if (this.getMembers().isEmpty()) {
            deletingTeam = true;
            this.invalidateTeam();
            this.manager.deleteTeam(this);
            this.manager.saveNow();
            this.manager.tryDeleteTeamFile(String.valueOf(this.getId()) + ".snbt", "party");
        }
        playerTeam.updatePresence();
        playerTeam.onPlayerChangeTeam(this, id, player, deletingTeam);
        this.manager.syncToAll(this, playerTeam);
        return 1;
    }

    public int addAlly(CommandSourceStack source, Collection<GameProfile> players) throws CommandSyntaxException {
        if (source.getPlayer() != null && !FTBTUtils.canPlayerUseCommand(source.getPlayer(), "ftbteams.party.allies.add")) {
            throw TeamArgument.NO_PERMISSION.create();
        }
        UUID from = source.getEntity() == null ? Util.NIL_UUID : source.getEntity().getUUID();
        ArrayList<GameProfile> addedPlayers = new ArrayList<GameProfile>();
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (this.isAllyOrBetter(id)) continue;
            this.ranks.put(id, TeamRank.ALLY);
            this.sendMessage(from, (Component)Component.translatable((String)"ftbteams.message.add_ally", (Object[])new Object[]{this.manager.getPlayerName(id).copy().withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GREEN));
            addedPlayers.add(player);
            ServerPlayer invitedPlayer = this.manager.getServer().getPlayerList().getPlayer(id);
            if (invitedPlayer == null) continue;
            invitedPlayer.displayClientMessage((Component)Component.translatable((String)"ftbteams.message.now_allied", (Object[])new Object[]{this.getDisplayName()}).withStyle(ChatFormatting.GREEN), false);
        }
        if (!addedPlayers.isEmpty()) {
            this.markDirty();
            this.manager.syncToAll(this);
            ((Consumer)TeamEvent.ADD_ALLY.invoker()).accept(new TeamAllyEvent(this, addedPlayers, true));
            return 1;
        }
        return 0;
    }

    public int removeAlly(CommandSourceStack source, Collection<GameProfile> players) throws CommandSyntaxException {
        UUID from = source.getEntity() == null ? Util.NIL_UUID : source.getEntity().getUUID();
        ArrayList<GameProfile> removedPlayers = new ArrayList<GameProfile>();
        for (GameProfile player : players) {
            UUID id = player.getId();
            if (!this.isAllyOrBetter(id) || this.isMember(id)) continue;
            this.ranks.remove(id);
            this.sendMessage(from, (Component)Component.translatable((String)"ftbteams.message.remove_ally", (Object[])new Object[]{this.manager.getPlayerName(id).copy().withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GOLD));
            removedPlayers.add(player);
            ServerPlayer removedPlayer = this.manager.getServer().getPlayerList().getPlayer(id);
            if (removedPlayer == null) continue;
            removedPlayer.displayClientMessage((Component)Component.translatable((String)"ftbteams.message.no_longer_allied", (Object[])new Object[]{this.getDisplayName()}).withStyle(ChatFormatting.GOLD), false);
        }
        if (!removedPlayers.isEmpty()) {
            this.markDirty();
            this.manager.syncToAll(this);
            ((Consumer)TeamEvent.REMOVE_ALLY.invoker()).accept(new TeamAllyEvent(this, removedPlayers, false));
            return 1;
        }
        return 0;
    }

    public int listAllies(CommandSourceStack source) {
        source.sendSuccess(() -> Component.literal((String)"Allies:"), false);
        boolean any = false;
        for (Map.Entry<UUID, TeamRank> entry : this.getPlayersByRank(TeamRank.ALLY).entrySet()) {
            if (entry.getValue().isAtLeast(TeamRank.MEMBER)) continue;
            source.sendSuccess(() -> this.manager.getPlayerName((UUID)entry.getKey()), false);
            any = true;
        }
        if (!any) {
            source.sendSuccess(() -> Component.literal((String)"None"), false);
        }
        return 1;
    }

    public int forceDisband(CommandSourceStack from) throws CommandSyntaxException {
        HashSet<UUID> members = new HashSet<UUID>(this.getMembers());
        members.remove(this.owner);
        this.kick(from, members.stream().map(id -> new GameProfile(id, "")).toList());
        this.leave(this.owner);
        from.sendSuccess(() -> Component.translatable((String)"ftbteams.message.team_disbanded", (Object[])new Object[]{this.getName(), this.getId()}).withStyle(ChatFormatting.GOLD), false);
        return 1;
    }
}

