/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.data;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbteams.FTBTeamsAPIImpl;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamInfoEvent;
import dev.ftb.mods.ftbteams.api.property.TeamPropertyArgument;
import dev.ftb.mods.ftbteams.data.PartyTeam;
import dev.ftb.mods.ftbteams.data.ServerTeam;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import dev.ftb.mods.ftbteams.data.TeamArgumentProvider;
import dev.ftb.mods.ftbteams.data.TeamManagerImpl;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;

public class FTBTeamsCommands {
    private Predicate<CommandSourceStack> requiresOPorSP() {
        return source -> source.getServer().isSingleplayer() || source.hasPermission(2);
    }

    private RequiredArgumentBuilder<CommandSourceStack, TeamArgumentProvider> teamArg() {
        return Commands.argument((String)"team", (ArgumentType)TeamArgument.create());
    }

    private String string(CommandContext<?> context, String name) {
        return StringArgumentType.getString(context, (String)name);
    }

    private boolean hasNoParty(CommandSourceStack source) {
        if (source.getEntity() instanceof ServerPlayer) {
            return FTBTeamsAPI.api().getManager().getTeamForPlayerID(source.getEntity().getUUID()).map(team -> !team.isPartyTeam()).orElse(false);
        }
        return false;
    }

    private boolean hasParty(CommandSourceStack source, TeamRank rank) {
        if (source.getEntity() instanceof ServerPlayer) {
            UUID playerId = source.getEntity().getUUID();
            return FTBTeamsAPI.api().getManager().getTeamForPlayerID(playerId).map(team -> team.isPartyTeam() && team.getRankForPlayer(playerId).isAtLeast(rank)).orElse(false);
        }
        return false;
    }

    private Team getTeam(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        return FTBTeamsAPI.api().getManager().getTeamForPlayer(player).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)player.getUUID()));
    }

    private PartyTeam getPartyTeam(CommandContext<CommandSourceStack> context, TeamRank minRank) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Team team = FTBTeamsAPI.api().getManager().getTeamForPlayer(player).orElseThrow(() -> TeamArgument.TEAM_NOT_FOUND.create((Object)player.getUUID()));
        if (!(team instanceof PartyTeam)) {
            throw TeamArgument.NOT_IN_PARTY.create();
        }
        PartyTeam partyTeam = (PartyTeam)team;
        if (!partyTeam.getRankForPlayer(player.getUUID()).isAtLeast(minRank)) {
            throw TeamArgument.CANT_EDIT.create((Object)team.getName());
        }
        return partyTeam;
    }

    private Team teamArg(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return TeamArgument.get(context, "team");
    }

    private Team teamArg(CommandContext<CommandSourceStack> context, Predicate<Team> predicate) throws CommandSyntaxException {
        Team team = this.teamArg(context);
        if (!predicate.test(team)) {
            throw TeamArgument.TEAM_NOT_FOUND.create((Object)team.getName());
        }
        return team;
    }

    private ServerTeam serverTeamArg(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return (ServerTeam)this.teamArg(context, Team::isServerTeam);
    }

    private PartyTeam partyTeamArg(CommandContext<CommandSourceStack> context, TeamRank rank) throws CommandSyntaxException {
        PartyTeam team = (PartyTeam)this.teamArg(context, Team::isPartyTeam);
        if (rank != TeamRank.NONE && !team.getRankForPlayer(((CommandSourceStack)context.getSource()).getPlayerOrException().getUUID()).isAtLeast(rank)) {
            throw TeamArgument.NOT_INVITED.create((Object)team.getName());
        }
        return team;
    }

    private int tryCreateParty(CommandSourceStack source, String partyName) throws CommandSyntaxException {
        if (FTBTeamsAPIImpl.INSTANCE.isPartyCreationFromAPIOnly()) {
            throw TeamArgument.API_OVERRIDE.create();
        }
        return (Integer)TeamManagerImpl.INSTANCE.createParty(source.getPlayerOrException(), partyName).getLeft();
    }

    public void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ftbteams").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"party").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"create").requires(this::hasNoParty)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.tryCreateParty((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"))))).executes(ctx -> this.tryCreateParty((CommandSourceStack)ctx.getSource(), "")))).then(((LiteralArgumentBuilder)Commands.literal((String)"join").requires(this::hasNoParty)).then(this.teamArg().executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.INVITED).join(((CommandSourceStack)ctx.getSource()).getPlayerOrException()))))).then(((LiteralArgumentBuilder)Commands.literal((String)"decline").requires(this::hasNoParty)).then(this.teamArg().executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.INVITED).declineInvitation((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)Commands.literal((String)"leave").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.MEMBER))).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.MEMBER).leave(((CommandSourceStack)ctx.getSource()).getPlayerOrException().getUUID())))).then(((LiteralArgumentBuilder)Commands.literal((String)"invite").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OFFICER))).then(Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OFFICER).invite(((CommandSourceStack)ctx.getSource()).getPlayerOrException(), GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"players")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"kick").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OFFICER))).then(Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OFFICER).kick((CommandSourceStack)ctx.getSource(), GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"players")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"transfer_ownership").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OWNER))).then(Commands.argument((String)"player_id", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.OWNER).transferOwnership((CommandSourceStack)ctx.getSource(), GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"player_id")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"transfer_ownership_for").requires(this.requiresOPorSP())).then(this.teamArg().then(Commands.argument((String)"player_id", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.NONE).transferOwnership((CommandSourceStack)ctx.getSource(), GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"player_id"))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"settings").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OWNER))).then(((RequiredArgumentBuilder)Commands.argument((String)"key", (ArgumentType)TeamPropertyArgument.create()).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OWNER).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), this.string(ctx, "value"))))).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OWNER).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), ""))))).then(((LiteralArgumentBuilder)Commands.literal((String)"settings_for").requires(this.requiresOPorSP())).then(this.teamArg().then(((RequiredArgumentBuilder)Commands.argument((String)"key", (ArgumentType)TeamPropertyArgument.create()).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.NONE).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), this.string(ctx, "value"))))).executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.NONE).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), "")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"allies").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.MEMBER))).then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OFFICER))).then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OFFICER).addAlly((CommandSourceStack)ctx.getSource(), GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.OFFICER))).then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.OFFICER).removeAlly((CommandSourceStack)ctx.getSource(), GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").requires(source -> this.hasParty((CommandSourceStack)source, TeamRank.MEMBER))).executes(ctx -> this.getPartyTeam((CommandContext<CommandSourceStack>)ctx, TeamRank.MEMBER).listAllies((CommandSourceStack)ctx.getSource())))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"server").requires(this.requiresOPorSP())).then(Commands.literal((String)"create").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> (Integer)TeamManagerImpl.INSTANCE.createServer((CommandSourceStack)ctx.getSource(), this.string(ctx, "name")).getLeft())))).then(Commands.literal((String)"delete").then(this.teamArg().executes(ctx -> this.serverTeamArg((CommandContext<CommandSourceStack>)ctx).delete((CommandSourceStack)ctx.getSource()))))).then(Commands.literal((String)"settings").then(this.teamArg().then(((RequiredArgumentBuilder)Commands.argument((String)"key", (ArgumentType)TeamPropertyArgument.create()).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.serverTeamArg((CommandContext<CommandSourceStack>)ctx).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), this.string(ctx, "value"))))).executes(ctx -> this.serverTeamArg((CommandContext<CommandSourceStack>)ctx).settings((CommandSourceStack)ctx.getSource(), TeamPropertyArgument.get((CommandContext<CommandSourceStack>)ctx, "key"), ""))))))).then(Commands.literal((String)"msg").then(Commands.argument((String)"text", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            this.getTeam((CommandContext<CommandSourceStack>)ctx).sendMessage(((CommandSourceStack)ctx.getSource()).getPlayerOrException().getUUID(), StringArgumentType.getString((CommandContext)ctx, (String)"text"));
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"info").then(Commands.literal((String)"server_id").executes(ctx -> this.serverId((CommandSourceStack)ctx.getSource())))).then(this.teamArg().executes(ctx -> this.info((CommandSourceStack)ctx.getSource(), this.teamArg((CommandContext<CommandSourceStack>)ctx))))).executes(ctx -> this.info((CommandSourceStack)ctx.getSource(), this.getTeam((CommandContext<CommandSourceStack>)ctx))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").executes(ctx -> this.list((CommandSourceStack)ctx.getSource(), null))).then(Commands.literal((String)"parties").executes(ctx -> this.list((CommandSourceStack)ctx.getSource(), Team::isPartyTeam)))).then(Commands.literal((String)"server_teams").executes(ctx -> this.list((CommandSourceStack)ctx.getSource(), Team::isServerTeam)))).then(Commands.literal((String)"players").executes(ctx -> this.list((CommandSourceStack)ctx.getSource(), Team::isPlayerTeam))))).then(((LiteralArgumentBuilder)Commands.literal((String)"force-disband").requires(source -> source.hasPermission(2))).then(this.teamArg().executes(ctx -> this.partyTeamArg((CommandContext<CommandSourceStack>)ctx, TeamRank.NONE).forceDisband((CommandSourceStack)ctx.getSource())))));
        if (Platform.isDevelopmentEnvironment()) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ftbteams_add_fake_player").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"profile", (ArgumentType)GameProfileArgument.gameProfile()).executes(ctx -> this.addFakePlayer(GameProfileArgument.getGameProfiles((CommandContext)ctx, (String)"profile")))));
        }
    }

    private int info(CommandSourceStack source, Team team) {
        team.getTeamInfo().forEach(line -> source.sendSuccess(() -> line, false));
        ((Consumer)TeamEvent.INFO.invoker()).accept(new TeamInfoEvent(team, source));
        return 1;
    }

    private int serverId(CommandSourceStack source) {
        UUID managerId = FTBTeamsAPI.api().getManager().getId();
        MutableComponent component = Component.literal((String)("Server ID: " + String.valueOf(managerId)));
        component.withStyle(style -> style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click to copy"))));
        component.withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, managerId.toString())));
        source.sendSuccess(() -> component, false);
        return 1;
    }

    private int list(CommandSourceStack source, @Nullable Predicate<Team> predicate) {
        MutableComponent list = Component.literal((String)"");
        boolean first = true;
        for (Team team : FTBTeamsAPI.api().getManager().getTeams()) {
            if (predicate != null && !predicate.test(team)) continue;
            if (first) {
                first = false;
            } else {
                list.append(", ");
            }
            list.append(team.getName());
        }
        MutableComponent msg = Component.translatable((String)"ftbteams.list", (Object[])new Object[]{first ? Component.translatable((String)"ftbteams.info.owner.none") : list});
        source.sendSuccess(() -> FTBTeamsCommands.lambda$list$51((Component)msg), false);
        return 1;
    }

    private int addFakePlayer(Collection<GameProfile> profiles) {
        for (GameProfile profile : profiles) {
            TeamManagerImpl.INSTANCE.playerLoggedIn(null, profile.getId(), profile.getName());
        }
        return 1;
    }

    private static /* synthetic */ Component lambda$list$51(Component msg) {
        return msg;
    }
}

