/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.packet;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import thelm.packagedauto.slot.FalseCopySlot;

public record SetItemStackPacket(short containerSlot, ItemStack stack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetItemStackPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"packagedauto:set_item_stack"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SetItemStackPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.SHORT, SetItemStackPacket::containerSlot, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, SetItemStackPacket::stack, SetItemStackPacket::new);

    public CustomPacketPayload.Type<SetItemStackPacket> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        Player player = ctx.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ctx.enqueueWork(() -> {
                Slot slot;
                AbstractContainerMenu container = player.containerMenu;
                if (container != null && this.containerSlot >= 0 && this.containerSlot < container.slots.size() && (slot = container.getSlot((int)this.containerSlot)) instanceof FalseCopySlot) {
                    FalseCopySlot fSlot = (FalseCopySlot)slot;
                    ItemStackHandler handler = (ItemStackHandler)fSlot.getItemHandler();
                    handler.setStackInSlot(slot.getSlotIndex(), this.stack.isEmpty() ? ItemStack.EMPTY : this.stack);
                }
            });
        }
    }
}

