/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.packet;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import thelm.packagedauto.client.DistributorRenderer;

public record DistributorBeamPacket(Vec3 source, Vec3 delta) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DistributorBeamPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"packagedauto:distributor_beam"));
    public static final StreamCodec<RegistryFriendlyByteBuf, DistributorBeamPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)StreamCodec.of(FriendlyByteBuf::writeVec3, FriendlyByteBuf::readVec3), DistributorBeamPacket::source, (StreamCodec)StreamCodec.of(FriendlyByteBuf::writeVec3, FriendlyByteBuf::readVec3), DistributorBeamPacket::delta, DistributorBeamPacket::new);

    public CustomPacketPayload.Type<DistributorBeamPacket> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> DistributorRenderer.INSTANCE.addBeam(this.source, this.delta));
    }

    public static void sendBeam(ServerLevel level, Vec3 source, Vec3 delta, double range) {
        PacketDistributor.sendToPlayersNear((ServerLevel)level, null, (double)source.x, (double)source.y, (double)source.z, (double)range, (CustomPacketPayload)new DistributorBeamPacket(source, delta), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

