/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.menu;

import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.slot.FalseCopySlot;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.OptionalIntDataSlot;

public class BaseMenu<T extends BaseBlockEntity>
extends AbstractContainerMenu {
    public final T blockEntity;
    public final Inventory inventory;
    public final BaseItemHandler<?> itemHandler;

    public BaseMenu(MenuType<?> menuType, int windowId, Inventory inventory, T blockEntity) {
        super(menuType, windowId);
        this.blockEntity = blockEntity;
        this.inventory = inventory;
        this.itemHandler = blockEntity != null ? ((BaseBlockEntity)((Object)blockEntity)).getItemHandler() : new BaseItemHandler<Object>(null, 0);
        this.addDataSlots(this.itemHandler);
    }

    public int getPlayerInvX() {
        return 8;
    }

    public int getPlayerInvY() {
        return 84;
    }

    public void setupPlayerInventory() {
        int i;
        int xOffset = this.getPlayerInvX();
        int yOffset = this.getPlayerInvY();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)this.inventory, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)this.inventory, i, xOffset + i * 18, yOffset + 58));
        }
    }

    protected void addDataSlots(ContainerData array) {
        for (int i = 0; i < array.getCount(); ++i) {
            this.addDataSlot(OptionalIntDataSlot.of(array, i));
        }
    }

    public int getSizeInventory() {
        return this.itemHandler.getSlots();
    }

    public boolean supportsShiftClick(Player player, int slotIndex) {
        return true;
    }

    public boolean performMerge(Player player, int slotIndex, ItemStack stack) {
        int invBase = this.getSizeInventory();
        int invFull = this.slots.size();
        if (slotIndex < invBase) {
            return this.moveItemStackTo(stack, invBase, invFull, true);
        }
        return this.moveItemStackTo(stack, 0, invBase, false);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        if (!this.supportsShiftClick(player, slotIndex)) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            stack = stackInSlot.copy();
            if (!this.performMerge(player, slotIndex, stackInSlot)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(stackInSlot, stack);
            if (stackInSlot.getCount() <= 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.set(stackInSlot);
            }
            if (stackInSlot.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stackInSlot);
        }
        return stack;
    }

    protected boolean moveItemStackTo(ItemStack stack, int slotMin, int slotMax, boolean ascending) {
        int maxStack;
        int rmv;
        ItemStack existingStack;
        Slot slot;
        int iterOrder;
        boolean successful = false;
        int i = !ascending ? slotMin : slotMax - 1;
        int n = iterOrder = !ascending ? 1 : -1;
        if (stack.isStackable()) {
            while (stack.getCount() > 0 && (!ascending && i < slotMax || ascending && i >= slotMin)) {
                slot = (Slot)this.slots.get(i);
                if (slot instanceof FalseCopySlot) {
                    i += iterOrder;
                    continue;
                }
                existingStack = slot.getItem();
                if (!existingStack.isEmpty() && slot.mayPlace(MiscHelper.INSTANCE.cloneStack(stack, rmv = Math.min(maxStack = Math.min(stack.getMaxStackSize(), slot.getMaxStackSize()), stack.getCount()))) && ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)existingStack)) {
                    int existingSize = existingStack.getCount() + stack.getCount();
                    if (existingSize <= maxStack) {
                        stack.setCount(0);
                        existingStack.setCount(existingSize);
                        slot.set(existingStack);
                        successful = true;
                    } else if (existingStack.getCount() < maxStack) {
                        stack.shrink(maxStack - existingStack.getCount());
                        existingStack.setCount(maxStack);
                        slot.set(existingStack);
                        successful = true;
                    }
                }
                i += iterOrder;
            }
        }
        if (stack.getCount() > 0) {
            int n2 = i = !ascending ? slotMin : slotMax - 1;
            while (stack.getCount() > 0 && (!ascending && i < slotMax || ascending && i >= slotMin)) {
                slot = (Slot)this.slots.get(i);
                if (slot instanceof FalseCopySlot) {
                    i += iterOrder;
                    continue;
                }
                existingStack = slot.getItem();
                if (existingStack.isEmpty() && slot.mayPlace(MiscHelper.INSTANCE.cloneStack(stack, rmv = Math.min(maxStack = Math.min(stack.getMaxStackSize(), slot.getMaxStackSize()), stack.getCount())))) {
                    existingStack = stack.split(rmv);
                    slot.set(existingStack);
                    successful = true;
                }
                i += iterOrder;
            }
        }
        return successful;
    }

    public void clicked(int slotId, int mouseButton, ClickType clickType, Player player) {
        Object object;
        if (slotId >= 0 && !this.getCarried().isEmpty() && (object = this.slots.get(slotId)) instanceof FalseCopySlot) {
            FalseCopySlot slot = (FalseCopySlot)((Object)object);
            ItemStack toPut = this.getCarried().copy();
            ItemStack stack = slot.getItem().copy();
            switch (mouseButton) {
                case 0: {
                    slot.set(toPut);
                    break;
                }
                case 1: {
                    if (stack.isEmpty()) {
                        toPut.setCount(1);
                        slot.set(toPut);
                        break;
                    }
                    if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)toPut) || stack.getCount() >= stack.getMaxStackSize()) break;
                    stack.grow(1);
                    slot.set(stack);
                }
            }
        } else {
            super.clicked(slotId, mouseButton, clickType, player);
        }
    }

    public boolean stillValid(Player player) {
        if (this.blockEntity != null) {
            return Container.stillValidBlockEntity(this.blockEntity, (Player)player);
        }
        return true;
    }
}

