/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import java.util.Collection;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;
import thelm.packagedauto.block.entity.PackagingProviderBlockEntity;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.inventory.BaseItemHandler;

public class PackagingProviderItemHandler
extends BaseItemHandler<PackagingProviderBlockEntity> {
    public PackagingProviderItemHandler(PackagingProviderBlockEntity blockEntity) {
        super(blockEntity, 1);
    }

    @Override
    protected void onContentsChanged(int slot) {
        this.updateRecipeList();
        super.onContentsChanged(slot);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.has(PackagedAutoDataComponents.RECIPE_LIST);
    }

    @Override
    public void load(CompoundTag nbt, HolderLookup.Provider registries) {
        super.load(nbt, registries);
        this.updateRecipeList();
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return (IItemHandlerModifiable)EmptyItemHandler.INSTANCE;
    }

    @Override
    public int get(int id) {
        return switch (id) {
            case 0 -> {
                if (((PackagingProviderBlockEntity)this.blockEntity).blocking) {
                    yield 1;
                }
                yield 0;
            }
            case 1 -> {
                if (((PackagingProviderBlockEntity)this.blockEntity).provideDirect) {
                    yield 1;
                }
                yield 0;
            }
            case 2 -> {
                if (((PackagingProviderBlockEntity)this.blockEntity).providePackaging) {
                    yield 1;
                }
                yield 0;
            }
            case 3 -> {
                if (((PackagingProviderBlockEntity)this.blockEntity).provideUnpackaging) {
                    yield 1;
                }
                yield 0;
            }
            default -> 0;
        };
    }

    @Override
    public void set(int id, int value) {
        switch (id) {
            case 0: {
                ((PackagingProviderBlockEntity)this.blockEntity).blocking = value != 0;
                break;
            }
            case 1: {
                ((PackagingProviderBlockEntity)this.blockEntity).provideDirect = value != 0;
                break;
            }
            case 2: {
                ((PackagingProviderBlockEntity)this.blockEntity).providePackaging = value != 0;
                break;
            }
            case 3: {
                ((PackagingProviderBlockEntity)this.blockEntity).provideUnpackaging = value != 0;
            }
        }
    }

    @Override
    public int getCount() {
        return 4;
    }

    public void updateRecipeList() {
        ((PackagingProviderBlockEntity)this.blockEntity).recipeList.clear();
        ItemStack listStack = this.getStackInSlot(0);
        if (listStack.has(PackagedAutoDataComponents.RECIPE_LIST)) {
            ((PackagingProviderBlockEntity)this.blockEntity).recipeList.addAll((Collection)listStack.get(PackagedAutoDataComponents.RECIPE_LIST));
        }
        if (((PackagingProviderBlockEntity)this.blockEntity).getLevel() != null && !((PackagingProviderBlockEntity)this.blockEntity).getLevel().isClientSide) {
            ((PackagingProviderBlockEntity)this.blockEntity).postPatternChange();
        }
    }
}

