/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.block.entity.PackagerBlockEntity;
import thelm.packagedauto.block.entity.PackagerExtensionBlockEntity;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.inventory.PackagerItemHandlerWrapper;
import thelm.packagedauto.util.MiscHelper;

public class PackagerItemHandler
extends BaseItemHandler<PackagerBlockEntity> {
    public PackagerItemHandler(PackagerBlockEntity blockEntity) {
        super(blockEntity, 12);
    }

    @Override
    protected void onContentsChanged(int slot) {
        if (slot < 9 && !((PackagerBlockEntity)this.blockEntity).getLevel().isClientSide && ((PackagerBlockEntity)this.blockEntity).isWorking && !this.getStackInSlot(slot).isEmpty() && !((PackagerBlockEntity)this.blockEntity).isInputValid()) {
            ((PackagerBlockEntity)this.blockEntity).endProcess();
        }
        if (slot == 10) {
            this.updatePatternList();
        }
        super.onContentsChanged(slot);
    }

    public int getSlotLimit(int slot) {
        if (slot == 10) {
            return 1;
        }
        return super.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return switch (slot) {
            case 9 -> false;
            case 10 -> {
                if (stack.has(PackagedAutoDataComponents.RECIPE_LIST) || MiscHelper.INSTANCE.isPackage(stack)) {
                    yield true;
                }
                yield false;
            }
            case 11 -> {
                if (stack.getCapability(Capabilities.EnergyStorage.ITEM) != null) {
                    yield true;
                }
                yield false;
            }
            default -> {
                if (((PackagerBlockEntity)this.blockEntity).isWorking) {
                    if (!this.getStackInSlot(slot).isEmpty()) {
                        yield true;
                    }
                    yield false;
                }
                yield true;
            }
        };
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this.wrapperMap.computeIfAbsent(side, s -> new PackagerItemHandlerWrapper(this, (Direction)s));
    }

    @Override
    public int get(int id) {
        return switch (id) {
            case 0 -> ((PackagerBlockEntity)this.blockEntity).remainingProgress;
            case 1 -> {
                if (((PackagerBlockEntity)this.blockEntity).isWorking) {
                    yield 1;
                }
                yield 0;
            }
            case 2 -> ((PackagerBlockEntity)this.blockEntity).mode.ordinal();
            case 3 -> ((PackagerBlockEntity)this.blockEntity).getEnergyStorage().getEnergyStored();
            default -> 0;
        };
    }

    @Override
    public void set(int id, int value) {
        switch (id) {
            case 0: {
                ((PackagerBlockEntity)this.blockEntity).remainingProgress = value;
                break;
            }
            case 1: {
                ((PackagerBlockEntity)this.blockEntity).isWorking = value != 0;
                break;
            }
            case 2: {
                ((PackagerBlockEntity)this.blockEntity).mode = PackagerBlockEntity.Mode.values()[value];
                break;
            }
            case 3: {
                ((PackagerBlockEntity)this.blockEntity).getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    @Override
    public int getCount() {
        return 4;
    }

    @Override
    public void load(CompoundTag nbt, HolderLookup.Provider registries) {
        super.load(nbt, registries);
        this.updatePatternList();
    }

    public void updatePatternList() {
        ((PackagerBlockEntity)this.blockEntity).patternList.clear();
        ItemStack listStack = this.getStackInSlot(10);
        if (listStack.has(PackagedAutoDataComponents.RECIPE_LIST)) {
            ((List)listStack.get(PackagedAutoDataComponents.RECIPE_LIST)).stream().filter(IPackageRecipeInfo::isValid).forEach(recipe -> {
                recipe.getPatterns().forEach(((PackagerBlockEntity)this.blockEntity).patternList::add);
                recipe.getExtraPatterns().forEach(((PackagerBlockEntity)this.blockEntity).patternList::add);
            });
        } else if (MiscHelper.INSTANCE.isPackage(listStack)) {
            IPackageRecipeInfo recipe2 = (IPackageRecipeInfo)listStack.get(PackagedAutoDataComponents.RECIPE);
            int index = (Integer)listStack.get(PackagedAutoDataComponents.PACKAGE_INDEX);
            if (recipe2.isValid() && recipe2.validPatternIndex(index)) {
                ((PackagerBlockEntity)this.blockEntity).patternList.add(recipe2.getPatterns().get(index));
            }
        }
        switch (((PackagerBlockEntity)this.blockEntity).mode) {
            default: {
                throw new MatchException(null, null);
            }
            case EXACT: {
                boolean bl = false;
                break;
            }
            case DISJOINT: {
                boolean bl = MiscHelper.INSTANCE.arePatternsDisjoint(((PackagerBlockEntity)this.blockEntity).patternList);
                break;
            }
            case FIRST: {
                boolean bl = ((PackagerBlockEntity)this.blockEntity).disjoint = true;
            }
        }
        if (((PackagerBlockEntity)this.blockEntity).getLevel() != null && !((PackagerBlockEntity)this.blockEntity).getLevel().isClientSide) {
            ((PackagerBlockEntity)this.blockEntity).postPatternChange();
        }
        if (((PackagerBlockEntity)this.blockEntity).getLevel() != null) {
            BlockPos.betweenClosedStream((BlockPos)((PackagerBlockEntity)this.blockEntity).getBlockPos().offset(-1, -1, -1), (BlockPos)((PackagerBlockEntity)this.blockEntity).getBlockPos().offset(1, 1, 1)).map(arg_0 -> ((Level)((PackagerBlockEntity)this.blockEntity).getLevel()).getBlockEntity(arg_0)).filter(t -> t instanceof PackagerExtensionBlockEntity).map(t -> (PackagerExtensionBlockEntity)((Object)t)).forEach(t -> t.updatePatternList());
        }
    }
}

