/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import thelm.packagedauto.block.entity.PackagerBlockEntity;
import thelm.packagedauto.block.entity.PackagerExtensionBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.inventory.PackagerExtensionItemHandlerWrapper;

public class PackagerExtensionItemHandler
extends BaseItemHandler<PackagerExtensionBlockEntity> {
    public PackagerExtensionItemHandler(PackagerExtensionBlockEntity blockEntity) {
        super(blockEntity, 11);
    }

    @Override
    protected void onContentsChanged(int slot) {
        if (slot < 9 && !((PackagerExtensionBlockEntity)this.blockEntity).getLevel().isClientSide && ((PackagerExtensionBlockEntity)this.blockEntity).isWorking && !this.getStackInSlot(slot).isEmpty() && !((PackagerExtensionBlockEntity)this.blockEntity).isInputValid()) {
            ((PackagerExtensionBlockEntity)this.blockEntity).endProcess();
        }
        super.onContentsChanged(slot);
    }

    public boolean isItemValid(int index, ItemStack stack) {
        return switch (index) {
            case 9 -> false;
            case 10 -> {
                if (stack.getCapability(Capabilities.EnergyStorage.ITEM) != null) {
                    yield true;
                }
                yield false;
            }
            default -> {
                if (((PackagerExtensionBlockEntity)this.blockEntity).isWorking) {
                    if (!this.getStackInSlot(index).isEmpty()) {
                        yield true;
                    }
                    yield false;
                }
                yield true;
            }
        };
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this.wrapperMap.computeIfAbsent(side, s -> new PackagerExtensionItemHandlerWrapper(this, (Direction)s));
    }

    @Override
    public int get(int id) {
        return switch (id) {
            case 0 -> ((PackagerExtensionBlockEntity)this.blockEntity).remainingProgress;
            case 1 -> {
                if (((PackagerExtensionBlockEntity)this.blockEntity).isWorking) {
                    yield 1;
                }
                yield 0;
            }
            case 2 -> ((PackagerExtensionBlockEntity)this.blockEntity).mode.ordinal();
            case 3 -> ((PackagerExtensionBlockEntity)this.blockEntity).getEnergyStorage().getEnergyStored();
            default -> 0;
        };
    }

    @Override
    public void set(int id, int value) {
        switch (id) {
            case 0: {
                ((PackagerExtensionBlockEntity)this.blockEntity).remainingProgress = value;
                break;
            }
            case 1: {
                ((PackagerExtensionBlockEntity)this.blockEntity).isWorking = value != 0;
                break;
            }
            case 2: {
                ((PackagerExtensionBlockEntity)this.blockEntity).mode = PackagerBlockEntity.Mode.values()[value];
                break;
            }
            case 3: {
                ((PackagerExtensionBlockEntity)this.blockEntity).getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    @Override
    public int getCount() {
        return 4;
    }
}

