/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import thelm.packagedauto.block.entity.FluidPackageFillerBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.inventory.FluidPackageFillerItemHandlerWrapper;

public class FluidPackageFillerItemHandler
extends BaseItemHandler<FluidPackageFillerBlockEntity> {
    public FluidPackageFillerItemHandler(FluidPackageFillerBlockEntity blockEntity) {
        super(blockEntity, 3);
    }

    public boolean isItemValid(int index, ItemStack stack) {
        return switch (index) {
            case 1 -> false;
            case 2 -> {
                if (stack.getCapability(Capabilities.EnergyStorage.ITEM) != null) {
                    yield true;
                }
                yield false;
            }
            default -> (!((FluidPackageFillerBlockEntity)this.blockEntity).isWorking || !this.getStackInSlot(index).isEmpty()) && FluidUtil.getFluidHandler((ItemStack)stack).isPresent();
        };
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this.wrapperMap.computeIfAbsent(side, s -> new FluidPackageFillerItemHandlerWrapper(this, (Direction)s));
    }

    @Override
    public int get(int id) {
        return switch (id) {
            case 0 -> ((FluidPackageFillerBlockEntity)this.blockEntity).requiredAmount;
            case 1 -> ((FluidPackageFillerBlockEntity)this.blockEntity).amount;
            case 2 -> ((FluidPackageFillerBlockEntity)this.blockEntity).remainingProgress;
            case 3 -> {
                if (((FluidPackageFillerBlockEntity)this.blockEntity).isWorking) {
                    yield 1;
                }
                yield 0;
            }
            case 4 -> ((FluidPackageFillerBlockEntity)this.blockEntity).getEnergyStorage().getEnergyStored();
            default -> 0;
        };
    }

    @Override
    public void set(int id, int value) {
        switch (id) {
            case 0: {
                ((FluidPackageFillerBlockEntity)this.blockEntity).requiredAmount = value;
                break;
            }
            case 1: {
                ((FluidPackageFillerBlockEntity)this.blockEntity).amount = value;
                break;
            }
            case 2: {
                ((FluidPackageFillerBlockEntity)this.blockEntity).remainingProgress = value;
                break;
            }
            case 3: {
                ((FluidPackageFillerBlockEntity)this.blockEntity).isWorking = value != 0;
                break;
            }
            case 4: {
                ((FluidPackageFillerBlockEntity)this.blockEntity).getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    @Override
    public int getCount() {
        return 5;
    }
}

