/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import com.google.common.primitives.Ints;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.EmptyItemHandler;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.block.entity.DistributorBlockEntity;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.inventory.BaseItemHandler;

public class DistributorItemHandler
extends BaseItemHandler<DistributorBlockEntity> {
    public DistributorItemHandler(DistributorBlockEntity blockEntity) {
        super(blockEntity, 81);
    }

    @Override
    protected void onContentsChanged(int slot) {
        this.loadMarker(slot);
        super.onContentsChanged(slot);
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.has(PackagedAutoDataComponents.MARKER_POS);
    }

    @Override
    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return (IItemHandlerModifiable)EmptyItemHandler.INSTANCE;
    }

    @Override
    public void load(CompoundTag nbt, HolderLookup.Provider registries) {
        super.load(nbt, registries);
        for (int i = 0; i < 81; ++i) {
            this.loadMarker(i);
        }
    }

    public void loadMarker(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack.has(PackagedAutoDataComponents.MARKER_POS)) {
            DirectionalGlobalPos pos = (DirectionalGlobalPos)stack.get(PackagedAutoDataComponents.MARKER_POS);
            if (((DistributorBlockEntity)this.blockEntity).getLevel() != null && !((DistributorBlockEntity)this.blockEntity).getLevel().dimension().equals(pos.dimension())) {
                ((DistributorBlockEntity)this.blockEntity).positions.remove(slot);
            } else {
                BlockPos dirVec = pos.blockPos().subtract((Vec3i)((DistributorBlockEntity)this.blockEntity).getBlockPos());
                int dist = Ints.max((int[])new int[]{Math.abs(dirVec.getX()), Math.abs(dirVec.getY()), Math.abs(dirVec.getZ())});
                if (dist <= DistributorBlockEntity.range) {
                    ((DistributorBlockEntity)this.blockEntity).positions.put(slot, (Object)pos);
                }
            }
        } else {
            ((DistributorBlockEntity)this.blockEntity).positions.remove(slot);
        }
    }
}

