/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.inventory;

import java.util.Arrays;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.api.IVolumeType;

public class BaseVolumeInventory {
    public final IVolumeType type;
    public final IVolumeStackWrapper[] stacks;

    public BaseVolumeInventory(IVolumeType type, int size) {
        this.type = type;
        this.stacks = new IVolumeStackWrapper[size];
        Arrays.fill(this.stacks, type.getEmptyStackInstance());
    }

    public int getSlots() {
        return this.stacks.length;
    }

    public boolean isEmpty() {
        for (IVolumeStackWrapper stack : this.stacks) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public IVolumeStackWrapper getStackInSlot(int index) {
        return index >= 0 && index < this.stacks.length ? this.stacks[index] : this.type.getEmptyStackInstance();
    }

    public void setStackInSlot(int index, IVolumeStackWrapper stack) {
        if (index >= 0 && index < this.stacks.length) {
            if (stack.isEmpty()) {
                stack = this.type.getEmptyStackInstance();
            }
            this.stacks[index] = stack;
        }
    }

    public void load(CompoundTag nbt, HolderLookup.Provider registries) {
        Arrays.fill(this.stacks, this.type.getEmptyStackInstance());
        ListTag tagList = nbt.getList("volumes", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag tag = tagList.getCompound(i);
            int j = tag.getByte("slot") & 0xFF;
            if (j < 0 || j >= this.stacks.length) continue;
            this.stacks[j] = this.type.loadRawStack(tag, registries);
        }
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider registries) {
        ListTag tagList = new ListTag();
        for (int i = 0; i < this.stacks.length; ++i) {
            IVolumeStackWrapper stack = this.stacks[i];
            if (stack.isEmpty()) continue;
            CompoundTag tag = new CompoundTag();
            tag.putByte("slot", (byte)i);
            this.type.saveRawStack(tag, stack, registries);
            tagList.add((Object)tag);
        }
        nbt.put("volumes", (Tag)tagList);
        return nbt;
    }
}

