/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.integration.jei.category.FluidPackageContentsCategory;
import thelm.packagedauto.integration.jei.category.FluidPackageFillingCategory;
import thelm.packagedauto.volume.FluidVolumeType;

public class FluidPackageManagerPlugin
implements IRecipeManagerPlugin {
    public <V> List<RecipeType<?>> getRecipeTypes(IFocus<V> focus) {
        IVolumeStackWrapper vStack;
        ItemStack stack;
        Object ingredient = focus.getTypedValue().getIngredient();
        if (ingredient instanceof ItemStack && (stack = (ItemStack)ingredient).has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK) && (vStack = (IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType() == FluidVolumeType.INSTANCE) {
            switch (focus.getRole()) {
                case INPUT: {
                    return List.of(FluidPackageContentsCategory.TYPE);
                }
                case OUTPUT: {
                    return List.of(FluidPackageFillingCategory.TYPE);
                }
            }
        }
        if (ingredient instanceof FluidStack) {
            stack = (FluidStack)ingredient;
            switch (focus.getRole()) {
                case INPUT: {
                    return List.of(FluidPackageFillingCategory.TYPE);
                }
                case OUTPUT: {
                    return List.of(FluidPackageContentsCategory.TYPE);
                }
            }
        }
        return List.of();
    }

    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        Object vStack;
        ItemStack stack;
        RecipeType type = recipeCategory.getRecipeType();
        Object ingredient = focus.getTypedValue().getIngredient();
        if (ingredient instanceof ItemStack && (stack = (ItemStack)ingredient).has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK) && (vStack = (IVolumeStackWrapper)stack.get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).getVolumeType() == FluidVolumeType.INSTANCE && (FluidPackageContentsCategory.TYPE.equals((Object)type) || FluidPackageFillingCategory.TYPE.equals((Object)type))) {
            return List.of(vStack);
        }
        if (ingredient instanceof FluidStack) {
            stack = (FluidStack)ingredient;
            if ((FluidPackageContentsCategory.TYPE.equals((Object)type) || FluidPackageFillingCategory.TYPE.equals((Object)type)) && ((Optional)(vStack = FluidVolumeType.INSTANCE.wrapStack(stack))).isPresent()) {
                return List.of((IVolumeStackWrapper)((Optional)vStack).get());
            }
        }
        return List.of();
    }

    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        return List.of();
    }
}

