/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.appeng.blockentity;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnit;
import appeng.api.crafting.IPatternDetails;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridHelper;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.block.PackagedAutoBlocks;
import thelm.packagedauto.block.entity.PackagerBlockEntity;
import thelm.packagedauto.integration.appeng.recipe.PackageCraftingPatternDetails;

public class AEPackagerBlockEntity
extends PackagerBlockEntity
implements IInWorldGridNodeHost,
IGridNodeListener<AEPackagerBlockEntity>,
IActionHost,
ICraftingProvider {
    public IActionSource source = IActionSource.ofMachine((IActionHost)this);
    public IManagedGridNode gridNode;

    public AEPackagerBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.getMainNode().create(this.level, this.worldPosition);
        }
        super.tick();
        if (drawMEEnergy && !this.level.isClientSide && this.level.getGameTime() % 8L == 0L) {
            this.chargeMEEnergy();
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (this.gridNode != null) {
            this.gridNode.destroy();
        }
    }

    public IGridNode getGridNode(Direction dir) {
        return this.getActionableNode();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.SMART;
    }

    public void onSaveChanges(AEPackagerBlockEntity nodeOwner, IGridNode node) {
        this.setChanged();
    }

    public IManagedGridNode getMainNode() {
        if (this.gridNode == null) {
            this.gridNode = GridHelper.createManagedNode((Object)((Object)this), (IGridNodeListener)this);
            this.gridNode.setTagName("node");
            this.gridNode.setVisualRepresentation(PackagedAutoBlocks.PACKAGER);
            this.gridNode.setGridColor(AEColor.TRANSPARENT);
            this.gridNode.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            this.gridNode.addService(ICraftingProvider.class, (IGridNodeService)this);
            this.gridNode.setIdlePowerUsage(1.0);
            this.gridNode.setInWorldNode(true);
            if (this.ownerUUID != null && this.level instanceof ServerLevel) {
                this.gridNode.setOwningPlayerId(IPlayerRegistry.getMapping((Level)this.level).getPlayerId(this.ownerUUID));
            }
        }
        return this.gridNode;
    }

    public IGridNode getActionableNode() {
        return this.getMainNode().getNode();
    }

    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] inputHolder) {
        if (!this.isBusy() && patternDetails instanceof PackageCraftingPatternDetails) {
            PackageCraftingPatternDetails pattern = (PackageCraftingPatternDetails)patternDetails;
            ItemStack slotStack = this.itemHandler.getStackInSlot(9);
            ItemStack outputStack = pattern.pattern.getOutput();
            if (slotStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.getCount() + 1 <= outputStack.getMaxStackSize()) {
                this.currentPattern = pattern.pattern;
                this.lockPattern = true;
                List<ItemStack> inputs = pattern.pattern.getInputs();
                for (int i = 0; i < inputs.size(); ++i) {
                    this.itemHandler.setStackInSlot(i, inputs.get(i).copy());
                }
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        return this.isWorking || !this.itemHandler.getStacks().subList(0, 9).stream().allMatch(ItemStack::isEmpty);
    }

    public List<IPatternDetails> getAvailablePatterns() {
        return this.patternList.stream().map(pattern -> new PackageCraftingPatternDetails((IPackagePattern)pattern, (HolderLookup.Provider)this.level.registryAccess())).toList();
    }

    @Override
    protected void ejectItem() {
        if (this.getMainNode().isActive()) {
            int count;
            ItemStack is;
            AEItemKey key;
            MEStorage inventory;
            IGrid grid = this.getMainNode().getGrid();
            IStorageService storageService = grid.getStorageService();
            IEnergyService energyService = grid.getEnergyService();
            int inserted = (int)StorageHelper.poweredInsert((IEnergySource)energyService, (MEStorage)(inventory = storageService.getInventory()), (AEKey)(key = AEItemKey.of((ItemStack)(is = this.itemHandler.getStackInSlot(9)))), (long)(count = is.getCount()), (IActionSource)this.source, (Actionable)Actionable.MODULATE);
            if (inserted == count) {
                this.itemHandler.setStackInSlot(9, ItemStack.EMPTY);
            } else {
                this.itemHandler.setStackInSlot(9, key.toStack(count - inserted));
            }
        } else {
            super.ejectItem();
        }
    }

    @Override
    public void postPatternChange() {
        ICraftingProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    protected void chargeMEEnergy() {
        if (this.getMainNode().isActive()) {
            IGrid grid = this.getMainNode().getGrid();
            IEnergyService energyService = grid.getEnergyService();
            double conversion = PowerUnit.FE.convertTo(PowerUnit.AE, 1.0);
            int request = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            double available = energyService.extractAEPower(((double)request + 0.5) * conversion, Actionable.SIMULATE, PowerMultiplier.CONFIG);
            int extract = (int)(available / conversion);
            energyService.extractAEPower((double)extract * conversion, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.energyStorage.receiveEnergy(extract, false);
        }
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (nbt.contains("node")) {
            this.getMainNode().loadFromNBT(nbt);
        }
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        if (this.gridNode != null) {
            this.gridNode.saveToNBT(nbt);
        }
    }
}

