/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client.screen;

import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.client.screen.AmountSpecifyingScreen;
import thelm.packagedauto.client.screen.BaseScreen;
import thelm.packagedauto.menu.VolumeAmountSpecifyingMenu;
import thelm.packagedauto.packet.SetItemStackPacket;
import thelm.packagedauto.util.MiscHelper;

public class VolumeAmountSpecifyingScreen
extends AmountSpecifyingScreen<VolumeAmountSpecifyingMenu> {
    private int containerSlot;
    private IVolumeStackWrapper stack;
    private int maxAmount;

    public VolumeAmountSpecifyingScreen(BaseScreen<?> parent, Inventory inventory, int containerSlot, IVolumeStackWrapper stack, int maxAmount) {
        super(parent, new VolumeAmountSpecifyingMenu(inventory, stack), inventory, (Component)Component.translatable((String)"gui.packagedauto.volume_amount_specifying"));
        this.containerSlot = containerSlot;
        this.stack = stack;
        this.maxAmount = maxAmount;
    }

    @Override
    protected int getDefaultAmount() {
        return this.stack.getAmount();
    }

    @Override
    protected int getMaxAmount() {
        return this.maxAmount;
    }

    @Override
    protected int[] getIncrements() {
        return new int[]{100, 500, 1000};
    }

    @Override
    protected void onOkButtonPressed(boolean shiftDown) {
        try {
            int amount = Mth.clamp((int)Integer.parseInt(this.amountField.getValue()), (int)0, (int)this.maxAmount);
            IVolumeStackWrapper newStack = this.stack.withAmount(amount);
            PacketDistributor.sendToServer((CustomPacketPayload)new SetItemStackPacket((short)this.containerSlot, MiscHelper.INSTANCE.makeVolumePackage(newStack)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.close();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

