/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.network.PacketDistributor;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity;
import thelm.packagedauto.client.screen.BaseScreen;
import thelm.packagedauto.menu.UnpackagerMenu;
import thelm.packagedauto.packet.ChangeBlockingPacket;
import thelm.packagedauto.packet.TrackerCountPacket;

public class UnpackagerScreen
extends BaseScreen<UnpackagerMenu> {
    public static final ResourceLocation BACKGROUND = ResourceLocation.parse((String)"packagedauto:textures/gui/unpackager.png");

    public UnpackagerScreen(UnpackagerMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return BACKGROUND;
    }

    public void init() {
        this.clearWidgets();
        super.init();
        this.addRenderableWidget((GuiEventListener)new ButtonChangeBlocking(this.leftPos + 98, this.topPos + 16));
        this.addRenderableWidget((GuiEventListener)new ButtonTrackerCount(this, true, this.leftPos + 98, this.topPos + 34));
        this.addRenderableWidget((GuiEventListener)new ButtonTrackerCount(this, false, this.leftPos + 106, this.topPos + 34));
    }

    @Override
    protected void renderBgAdditional(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int scaledEnergy = ((UnpackagerBlockEntity)((UnpackagerMenu)this.menu).blockEntity).getScaledEnergy(40);
        graphics.blit(BACKGROUND, this.leftPos + 10, this.topPos + 10 + 40 - scaledEnergy, 176, 40 - scaledEnergy, 12, scaledEnergy);
        for (int i = 0; i < ((UnpackagerBlockEntity)((UnpackagerMenu)this.menu).blockEntity).trackers.length; ++i) {
            UnpackagerBlockEntity.PackageTracker tracker = ((UnpackagerBlockEntity)((UnpackagerMenu)this.menu).blockEntity).trackers[i];
            for (int j = 0; j < 9; ++j) {
                if (j < tracker.amount) {
                    if (tracker.received.getBoolean(j)) {
                        graphics.blit(BACKGROUND, this.leftPos + 115 + 6 * j, this.topPos + 16 + 6 * i, 176, 45, 6, 5);
                        continue;
                    }
                    graphics.blit(BACKGROUND, this.leftPos + 115 + 6 * j, this.topPos + 16 + 6 * i, 176, 40, 6, 5);
                    continue;
                }
                if (i < ((UnpackagerBlockEntity)((UnpackagerMenu)this.menu).blockEntity).trackerCount) {
                    graphics.blit(BACKGROUND, this.leftPos + 115 + 6 * j, this.topPos + 16 + 6 * i, 182, 45, 6, 5);
                    continue;
                }
                graphics.blit(BACKGROUND, this.leftPos + 115 + 6 * j, this.topPos + 16 + 6 * i, 182, 40, 6, 5);
            }
        }
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        String s = ((UnpackagerBlockEntity)((UnpackagerMenu)this.menu).blockEntity).getDisplayName().getString();
        graphics.drawString(this.font, s, this.imageWidth / 2 - this.font.width(s) / 2, 6, 0x404040, false);
        graphics.drawString(this.font, ((UnpackagerMenu)this.menu).inventory.getDisplayName().getString(), ((UnpackagerMenu)this.menu).getPlayerInvX(), ((UnpackagerMenu)this.menu).getPlayerInvY() - 11, 0x404040, false);
        if (mouseX - this.leftPos >= 10 && mouseY - this.topPos >= 10 && mouseX - this.leftPos <= 21 && mouseY - this.topPos <= 49) {
            graphics.renderTooltip(this.font, (Component)Component.literal((String)(((UnpackagerBlockEntity)((UnpackagerMenu)this.menu).blockEntity).getEnergyStorage().getEnergyStored() + " / " + ((UnpackagerBlockEntity)((UnpackagerMenu)this.menu).blockEntity).getEnergyStorage().getMaxEnergyStored() + " FE")), mouseX - this.leftPos, mouseY - this.topPos);
        }
        super.renderLabels(graphics, mouseX, mouseY);
    }

    class ButtonChangeBlocking
    extends AbstractButton {
        final Tooltip trueTooltip;
        final Tooltip falseTooltip;

        public ButtonChangeBlocking(int x, int y) {
            super(x, y, 16, 18, (Component)Component.empty());
            this.trueTooltip = Tooltip.create((Component)Component.translatable((String)"block.packagedauto.unpackager.blocking.true"));
            this.falseTooltip = Tooltip.create((Component)Component.translatable((String)"block.packagedauto.unpackager.blocking.false"));
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            this.setTooltip(((UnpackagerBlockEntity)((UnpackagerMenu)UnpackagerScreen.this.menu).blockEntity).blocking ? this.trueTooltip : this.falseTooltip);
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
            graphics.blit(BACKGROUND, this.getX() + 1, this.getY() + 2, 176, ((UnpackagerBlockEntity)((UnpackagerMenu)UnpackagerScreen.this.menu).blockEntity).blocking ? 64 : 50, 14, 14);
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public void onPress() {
            PacketDistributor.sendToServer((CustomPacketPayload)ChangeBlockingPacket.INSTANCE, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    class ButtonTrackerCount
    extends AbstractButton {
        boolean decrease;

        public ButtonTrackerCount(UnpackagerScreen this$0, boolean decrease, int x, int y) {
            super(x, y, 8, 18, (Component)Component.empty());
            this.decrease = decrease;
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)("block.packagedauto.unpackager.tracker." + (decrease ? "decrease" : "increase")))));
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
            graphics.blit(BACKGROUND, this.getX() + 1, this.getY() + 2, this.decrease ? 176 : 182, 78, 6, 14);
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public void onPress() {
            PacketDistributor.sendToServer((CustomPacketPayload)new TrackerCountPacket(this.decrease), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

