/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.block.entity.EncoderBlockEntity;
import thelm.packagedauto.client.screen.BaseScreen;
import thelm.packagedauto.menu.EncoderMenu;
import thelm.packagedauto.packet.CycleRecipeTypePacket;
import thelm.packagedauto.packet.LoadRecipeListPacket;
import thelm.packagedauto.packet.SaveRecipeListPacket;
import thelm.packagedauto.packet.SetPatternIndexPacket;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
public class EncoderScreen
extends BaseScreen<EncoderMenu> {
    public static final ResourceLocation BACKGROUND = ResourceLocation.parse((String)"packagedauto:textures/gui/encoder.png");

    public EncoderScreen(EncoderMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.imageWidth = 258;
        this.imageHeight = 314;
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return BACKGROUND;
    }

    public void init() {
        this.clearWidgets();
        super.init();
        int patternSlots = ((EncoderBlockEntity)((EncoderMenu)this.menu).blockEntity).patternItemHandlers.length;
        for (int i = 0; i < patternSlots; ++i) {
            this.addRenderableWidget((GuiEventListener)new ButtonPatternSlot(i, this.leftPos + 29 + i % 10 * 18, this.topPos + (patternSlots > 10 ? 16 : 25) + i / 10 * 18));
        }
        this.addRenderableWidget((GuiEventListener)new ButtonRecipeType(this.leftPos + 203, this.topPos + 74));
        this.addRenderableWidget((GuiEventListener)new ButtonSavePatterns(this, this.leftPos + 213, this.topPos + 16, (Component)Component.translatable((String)"block.packagedauto.encoder.save")));
        this.addRenderableWidget((GuiEventListener)new ButtonLoadPatterns(this.leftPos + 213, this.topPos + 34, (Component)Component.translatable((String)"block.packagedauto.encoder.load")));
    }

    @Override
    protected void renderBgAdditional(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int j;
        int i;
        IPackageRecipeType recipeType = ((EncoderMenu)this.menu).patternItemHandler.recipeType;
        for (i = 0; i < 9; ++i) {
            for (j = 0; j < 9; ++j) {
                Vec3i color = recipeType.getSlotColor(i * 9 + j);
                RenderSystem.setShaderColor((float)((float)color.getX() / 255.0f), (float)((float)color.getY() / 255.0f), (float)((float)color.getZ() / 255.0f), (float)1.0f);
                graphics.blit(BACKGROUND, this.leftPos + 8 + j * 18, this.topPos + 57 + i * 18, 258.0f, 0.0f, 16, 16, 512, 512);
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                int slotIndex = 81 + (i * 3 + j == 4 ? 0 : (i * 3 + j < 4 ? i * 3 + j + 1 : i * 3 + j));
                Vec3i color = recipeType.getSlotColor(slotIndex);
                RenderSystem.setShaderColor((float)((float)color.getX() / 255.0f), (float)((float)color.getY() / 255.0f), (float)((float)color.getZ() / 255.0f), (float)1.0f);
                graphics.blit(BACKGROUND, this.leftPos + 198 + j * 18, this.topPos + 111 + i * 18, 258.0f, 0.0f, 16, 16, 512, 512);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        String s = ((EncoderBlockEntity)((EncoderMenu)this.menu).blockEntity).getDisplayName().getString();
        graphics.drawString(this.font, s, this.imageWidth / 2 - this.font.width(s) / 2, 6, 0x404040, false);
        graphics.drawString(this.font, ((EncoderMenu)this.menu).inventory.getDisplayName().getString(), ((EncoderMenu)this.menu).getPlayerInvX(), ((EncoderMenu)this.menu).getPlayerInvY() - 11, 0x404040, false);
        String str = ((EncoderMenu)this.menu).patternItemHandler.recipeType.getShortDisplayName().getString();
        graphics.drawString(this.font, str, 212 - this.font.width(str) / 2, 64, 0x404040, false);
        super.renderLabels(graphics, mouseX, mouseY);
    }

    @Override
    public int getItemAmountSpecificationLimit(Slot slot) {
        int stackLimit = slot.getItem().getMaxStackSize();
        return slot.index > 81 ? Math.max(stackLimit, 999) : stackLimit;
    }

    class ButtonPatternSlot
    extends AbstractButton {
        int id;

        ButtonPatternSlot(int id, int x, int y) {
            super(x, y, 18, 18, (Component)Component.empty());
            this.id = id;
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)"block.packagedauto.encoder.pattern_slot", (Object[])new Object[]{String.format("%02d", id)})));
        }

        public boolean isHoveredOrFocused() {
            return super.isHoveredOrFocused() || ((EncoderBlockEntity)((EncoderMenu)EncoderScreen.this.menu).blockEntity).patternIndex == this.id;
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            for (int i = 81; i < 90; ++i) {
                ItemStack stack = ((EncoderBlockEntity)((EncoderMenu)EncoderScreen.this.menu).blockEntity).patternItemHandlers[this.id].getStackInSlot(i);
                if (stack.isEmpty()) continue;
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                graphics.renderItem(stack, this.getX() + 1, this.getY() + 1);
                break;
            }
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public void onPress() {
            PacketDistributor.sendToServer((CustomPacketPayload)new SetPatternIndexPacket(this.id), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ((EncoderBlockEntity)((EncoderMenu)EncoderScreen.this.menu).blockEntity).setPatternIndex(this.id);
            ((EncoderMenu)EncoderScreen.this.menu).setupSlots();
        }
    }

    class ButtonRecipeType
    extends AbstractButton {
        ButtonRecipeType(int x, int y) {
            super(x, y, 18, 18, (Component)Component.empty());
            this.setTooltip(Tooltip.create((Component)Component.translatable((String)"block.packagedauto.encoder.change_recipe_type")));
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
            IPackageRecipeType recipeType = ((EncoderMenu)EncoderScreen.this.menu).patternItemHandler.recipeType;
            if (recipeType != null) {
                Object rep = recipeType.getRepresentation();
                if (rep instanceof TextureAtlasSprite) {
                    TextureAtlasSprite sprite = (TextureAtlasSprite)rep;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    graphics.blit(this.getX() + 1, this.getY() + 1, 0, 16, 16, sprite);
                }
                if (rep instanceof ItemStack) {
                    ItemStack stack = (ItemStack)rep;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    graphics.renderItem(stack, this.getX() + 1, this.getY() + 1);
                }
            }
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public void onPress() {
            boolean reverse = Screen.hasShiftDown();
            PacketDistributor.sendToServer((CustomPacketPayload)new CycleRecipeTypePacket(reverse), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ((EncoderMenu)EncoderScreen.this.menu).patternItemHandler.cycleRecipeType(reverse);
            ((EncoderMenu)EncoderScreen.this.menu).setupSlots();
        }
    }

    class ButtonSavePatterns
    extends AbstractButton {
        final Tooltip tooltip = Tooltip.create((Component)Component.translatable((String)"block.packagedauto.encoder.save_single"));

        ButtonSavePatterns(EncoderScreen this$0, int x, int y, Component text) {
            super(x, y, 38, 18, text);
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.setTooltip(Screen.hasShiftDown() ? this.tooltip : null);
            super.renderWidget(graphics, mouseX, mouseY, partialTick);
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public void onPress() {
            boolean single = Screen.hasShiftDown();
            PacketDistributor.sendToServer((CustomPacketPayload)new SaveRecipeListPacket(single), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    class ButtonLoadPatterns
    extends AbstractButton {
        final Tooltip tooltip;

        ButtonLoadPatterns(int x, int y, Component text) {
            super(x, y, 38, 18, text);
            this.tooltip = Tooltip.create((Component)Component.translatable((String)"block.packagedauto.encoder.load_single"));
        }

        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            this.setTooltip(Screen.hasShiftDown() ? this.tooltip : null);
            super.renderWidget(graphics, mouseX, mouseY, partialTick);
        }

        public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        }

        public void onPress() {
            boolean single = Screen.hasShiftDown();
            PacketDistributor.sendToServer((CustomPacketPayload)new LoadRecipeListPacket(single), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ((EncoderBlockEntity)((EncoderMenu)EncoderScreen.this.menu).blockEntity).loadRecipeList(single);
            ((EncoderMenu)EncoderScreen.this.menu).setupSlots();
        }
    }
}

