/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.client.screen.ItemAmountSpecifyingScreen;
import thelm.packagedauto.client.screen.VolumeAmountSpecifyingScreen;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.menu.BaseMenu;
import thelm.packagedauto.slot.FalseCopySlot;
import thelm.packagedauto.slot.FalseCopyVolumeSlot;
import thelm.packagedauto.slot.PreviewSlot;

public abstract class BaseScreen<C extends BaseMenu<?>>
extends AbstractContainerScreen<C> {
    public final C menu;

    public BaseScreen(C menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.menu = menu;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
    }

    protected abstract ResourceLocation getBackgroundTexture();

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.imageWidth > 256 || this.imageHeight > 256) {
            graphics.blit(this.getBackgroundTexture(), this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 512);
        } else {
            graphics.blit(this.getBackgroundTexture(), this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        }
        this.renderBgAdditional(graphics, partialTicks, mouseX, mouseY);
        for (int i = 0; i < ((BaseMenu)((Object)this.menu)).slots.size(); ++i) {
            IVolumeStackWrapper stack;
            Slot slot = (Slot)((BaseMenu)((Object)this.menu)).slots.get(i);
            if (!slot.isActive()) continue;
            if (slot instanceof FalseCopyVolumeSlot) {
                FalseCopyVolumeSlot vSlot = (FalseCopyVolumeSlot)slot;
                stack = vSlot.volumeInventory.getStackInSlot(slot.getSlotIndex());
                if (stack.isEmpty()) continue;
                stack.getVolumeType().render(graphics, this.leftPos + slot.x, this.topPos + slot.y, stack);
                this.renderQuantity(graphics, this.leftPos + slot.x, this.topPos + slot.y, String.valueOf(stack.getAmount()), 0xFFFFFF);
                continue;
            }
            if (!(slot instanceof FalseCopySlot) && !(slot instanceof PreviewSlot) || !slot.getItem().has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK) || (stack = (IVolumeStackWrapper)slot.getItem().get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)).isEmpty()) continue;
            stack.getVolumeType().render(graphics, this.leftPos + slot.x, this.topPos + slot.y, stack);
        }
    }

    protected void renderBgAdditional(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        for (int i = 0; i < ((BaseMenu)((Object)this.menu)).slots.size(); ++i) {
            Slot slot = (Slot)((BaseMenu)((Object)this.menu)).slots.get(i);
            if (!slot.isActive() || !(slot instanceof FalseCopyVolumeSlot)) continue;
            FalseCopyVolumeSlot vSlot = (FalseCopyVolumeSlot)slot;
            IVolumeStackWrapper stack = vSlot.volumeInventory.getStackInSlot(slot.getSlotIndex());
            if (stack.isEmpty() || !this.inBounds(slot.x, slot.y, 17, 17, mouseX - this.leftPos, mouseY - this.topPos)) continue;
            graphics.renderComponentTooltip(this.font, stack.getTooltip(), mouseX - this.leftPos, mouseY - this.topPos);
        }
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        if (type != ClickType.QUICK_MOVE && (type != ClickType.CLONE || !this.minecraft.player.isCreative()) && this.menu.getCarried().isEmpty() && slot instanceof FalseCopySlot && slot.isActive() && !slot.getItem().isEmpty()) {
            if (!BaseScreen.hasControlDown() && slot.getItem().has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)) {
                this.minecraft.setScreen((Screen)new VolumeAmountSpecifyingScreen(this, this.minecraft.player.getInventory(), slot.index, (IVolumeStackWrapper)slot.getItem().get(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK), this.getVolumeAmountSpecificationLimit(slot)));
            } else {
                this.minecraft.setScreen((Screen)new ItemAmountSpecifyingScreen(this, this.minecraft.player.getInventory(), slot.index, slot.getItem(), this.getItemAmountSpecificationLimit(slot)));
            }
        }
        super.slotClicked(slot, slotId, mouseButton, type);
    }

    public int getItemAmountSpecificationLimit(Slot slot) {
        return Math.min(slot.getMaxStackSize(), slot.getItem().getMaxStackSize());
    }

    public int getVolumeAmountSpecificationLimit(Slot slot) {
        return 1000000;
    }

    public boolean inBounds(int x, int y, int w, int h, double ox, double oy) {
        return ox >= (double)x && ox <= (double)(x + w) && oy >= (double)y && oy <= (double)(y + h);
    }

    public void renderQuantity(GuiGraphics graphics, int x, int y, String qty, int color) {
        boolean large = this.minecraft.isEnforceUnicode();
        graphics.pose().pushPose();
        graphics.pose().translate((float)x, (float)y, 300.0f);
        if (!large) {
            graphics.pose().scale(0.5f, 0.5f, 1.0f);
        }
        graphics.drawString(this.font, qty, (large ? 16 : 30) - this.font.width(qty), large ? 8 : 22, color, true);
        graphics.pose().popPose();
    }
}

