/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import thelm.packagedauto.client.screen.BaseScreen;
import thelm.packagedauto.menu.BaseMenu;

public abstract class AmountSpecifyingScreen<C extends BaseMenu<?>>
extends BaseScreen<C> {
    public static final ResourceLocation BACKGROUND = ResourceLocation.parse((String)"packagedauto:textures/gui/amount_specifying.png");
    private BaseScreen<?> parent;
    protected EditBox amountField;

    public AmountSpecifyingScreen(BaseScreen<?> parent, C menu, Inventory inventory, Component title) {
        super(menu, inventory, title);
        this.imageWidth = 172;
        this.imageHeight = 99;
        this.parent = parent;
    }

    protected abstract int getDefaultAmount();

    protected abstract int getMaxAmount();

    protected abstract int[] getIncrements();

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return BACKGROUND;
    }

    protected void init() {
        String text;
        int increment;
        int i;
        this.clearWidgets();
        super.init();
        this.addRenderableWidget((GuiEventListener)new ButtonSet(this.leftPos + 114, this.topPos + 22, (Component)Component.translatable((String)"misc.packagedauto.set")));
        this.addRenderableWidget((GuiEventListener)new ButtonCancel(this.leftPos + 114, this.topPos + 22 + 24, (Component)Component.translatable((String)"gui.cancel")));
        Objects.requireNonNull(this.font);
        this.amountField = new EditBox(this.font, this.leftPos + 9, this.topPos + 51, 63, 9, (Component)Component.empty());
        this.amountField.setBordered(false);
        this.amountField.setValue(String.valueOf(this.getDefaultAmount()));
        this.amountField.setTextColor(0xFFFFFF);
        this.amountField.setFilter(s -> {
            if (s.isEmpty()) {
                return true;
            }
            try {
                int amount = Integer.parseInt(s);
                return amount >= 0 && amount <= this.getMaxAmount();
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        this.addRenderableWidget((GuiEventListener)this.amountField);
        int[] increments = this.getIncrements();
        int xx = 7;
        int width = 34;
        for (i = 0; i < 3; ++i) {
            increment = increments[i];
            text = "+" + increment;
            this.addRenderableWidget((GuiEventListener)new ButtonIncrement(increment, this.leftPos + xx, this.topPos + 20, (Component)Component.literal((String)text)));
            xx += width;
        }
        xx = 7;
        for (i = 0; i < 3; ++i) {
            increment = increments[i];
            text = "-" + increment;
            this.addRenderableWidget((GuiEventListener)new ButtonIncrement(-increment, this.leftPos + xx, this.topPos + this.imageHeight - 20 - 7, (Component)Component.literal((String)text)));
            xx += width;
        }
    }

    @Override
    protected void renderBgAdditional(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.amountField.renderWidget(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.getTitle().getString(), 7, 7, 0x404040, false);
        super.renderLabels(graphics, mouseX, mouseY);
    }

    public boolean keyPressed(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.close();
            return true;
        }
        if ((key == 257 || key == 335) && this.amountField.isFocused()) {
            this.onOkButtonPressed(AmountSpecifyingScreen.hasShiftDown());
            return true;
        }
        if (this.amountField.keyPressed(key, scanCode, modifiers)) {
            return true;
        }
        InputConstants.Key mouseKey = InputConstants.getKey((int)key, (int)scanCode);
        if (this.minecraft.options.keyInventory.isActiveAndMatches(mouseKey) && this.amountField.isFocused()) {
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    private void onIncrementButtonClicked(int increment) {
        int oldAmount = 0;
        try {
            oldAmount = Integer.parseInt(this.amountField.getValue());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int newAmount = Mth.clamp((int)(oldAmount + increment), (int)0, (int)this.getMaxAmount());
        this.amountField.setValue(String.valueOf(newAmount));
    }

    protected abstract void onOkButtonPressed(boolean var1);

    public void close() {
        this.minecraft.setScreen(this.parent);
    }

    public BaseScreen<?> getParent() {
        return this.parent;
    }

    class ButtonSet
    extends AbstractButton {
        public ButtonSet(int x, int y, Component text) {
            super(x, y, 50, 20, text);
        }

        public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
        }

        public void onPress() {
            AmountSpecifyingScreen.this.onOkButtonPressed(Screen.hasShiftDown());
        }
    }

    class ButtonCancel
    extends AbstractButton {
        public ButtonCancel(int x, int y, Component text) {
            super(x, y, 50, 20, text);
        }

        public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
        }

        public void onPress() {
            AmountSpecifyingScreen.this.close();
        }
    }

    class ButtonIncrement
    extends AbstractButton {
        int increment;

        public ButtonIncrement(int increment, int x, int y, Component text) {
            super(x, y, 34, 20, text);
            this.increment = increment;
        }

        public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
        }

        public void onPress() {
            AmountSpecifyingScreen.this.onIncrementButtonClicked(this.increment);
        }
    }
}

