/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client;

import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.OptionalDouble;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RegisterRenderBuffersEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.block.entity.DistributorBlockEntity;
import thelm.packagedauto.client.RenderTimer;
import thelm.packagedauto.component.PackagedAutoDataComponents;

public class DistributorRenderer {
    public static final DistributorRenderer INSTANCE = new DistributorRenderer();
    public static final Vec3 BLOCK_SIZE = new Vec3(1.0, 1.0, 1.0);
    public static final int BEAM_LIFETIME = 6;
    private List<BeamInfo> beams = new LinkedList<BeamInfo>();

    private DistributorRenderer() {
    }

    public void onConstruct() {
        NeoForge.EVENT_BUS.addListener(this::onRenderLevel);
    }

    public void onRegisterRenderBuffers(RegisterRenderBuffersEvent event) {
        event.registerRenderBuffer(RenderTypeHelper.MARKER_LINE_4);
        event.registerRenderBuffer(RenderTypeHelper.MARKER_QUAD);
        event.registerRenderBuffer(RenderTypeHelper.BEAM_LINE_3);
    }

    public void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_LEVEL) {
            return;
        }
        Matrix4fStack matrixStack = RenderSystem.getModelViewStack();
        matrixStack.pushMatrix();
        matrixStack.mul((Matrix4fc)event.getModelViewMatrix());
        RenderSystem.applyModelViewMatrix();
        LocalPlayer player = Minecraft.getInstance().player;
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.getItemInHand(hand);
            if (!stack.has(PackagedAutoDataComponents.MARKER_POS)) continue;
            this.renderMarker(event.getPoseStack(), (DirectionalGlobalPos)stack.get(PackagedAutoDataComponents.MARKER_POS));
        }
        this.renderBeams(event.getPoseStack(), event.getPartialTick());
        matrixStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    public void addBeam(Vec3 source, Vec3 delta) {
        this.beams.add(new BeamInfo(source, delta));
    }

    public void renderMarker(PoseStack poseStack, DirectionalGlobalPos globalPos) {
        if (globalPos == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (!globalPos.dimension().equals((Object)mc.level.dimension())) {
            return;
        }
        int range = 2 * DistributorBlockEntity.range + 2;
        BlockPos blockPos = globalPos.blockPos();
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        Vec3 distVec = cameraPos.subtract(blockPos.getCenter());
        double[] dArray = new double[]{Math.abs(distVec.x), Math.abs(distVec.y), Math.abs(distVec.z)};
        if (Doubles.max((double[])dArray) > (double)range) {
            return;
        }
        MultiBufferSource.BufferSource buffers = mc.renderBuffers().bufferSource();
        VertexConsumer quadBuffer = buffers.getBuffer(RenderTypeHelper.MARKER_QUAD);
        VertexConsumer lineBuffer = buffers.getBuffer(RenderTypeHelper.MARKER_LINE_4);
        poseStack.pushPose();
        poseStack.translate((double)blockPos.getX() - cameraPos.x, (double)blockPos.getY() - cameraPos.y, (double)blockPos.getZ() - cameraPos.z);
        Direction direction = globalPos.direction();
        this.addMarkerVertices(poseStack, quadBuffer, BLOCK_SIZE, direction, 0.0f, 1.0f, 1.0f, 0.5f);
        this.addMarkerVertices(poseStack, lineBuffer, BLOCK_SIZE, null, 0.0f, 1.0f, 1.0f, 1.0f);
        poseStack.popPose();
        RenderSystem.disableDepthTest();
        buffers.endBatch();
        RenderSystem.enableDepthTest();
    }

    public void renderBeams(PoseStack poseStack, DeltaTracker deltaTracker) {
        int currentTick = RenderTimer.INSTANCE.getTicks();
        this.beams.removeIf(beam -> beam.shouldRemove(currentTick));
        float renderTick = (float)currentTick + deltaTracker.getGameTimeDeltaPartialTick(true);
        Minecraft mc = Minecraft.getInstance();
        Vec3 cameraPos = mc.gameRenderer.getMainCamera().getPosition();
        MultiBufferSource.BufferSource buffers = mc.renderBuffers().bufferSource();
        VertexConsumer lineBuffer = buffers.getBuffer(RenderTypeHelper.BEAM_LINE_3);
        for (BeamInfo beam2 : this.beams) {
            Vec3 source = beam2.source();
            poseStack.pushPose();
            poseStack.translate(source.x - cameraPos.x, source.y - cameraPos.y, source.z - cameraPos.z);
            this.addBeamVertices(poseStack, lineBuffer, beam2.delta(), 0.0f, 1.0f, 1.0f, beam2.getAlpha(renderTick));
            poseStack.popPose();
        }
        buffers.endBatch();
    }

    public void addMarkerVertices(PoseStack poseStack, VertexConsumer buffer, Vec3 delta, Direction direction, float r, float g, float b, float a) {
        PoseStack.Pose pose = poseStack.last();
        float x = (float)delta.x;
        float y = (float)delta.y;
        float z = (float)delta.z;
        if (direction == null || direction == Direction.NORTH) {
            buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, x, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, x, y, 0.0f).setColor(r, g, b, a).setNormal(pose, -1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, 0.0f, y, 0.0f).setColor(r, g, b, a).setNormal(pose, -1.0f, 0.0f, 0.0f);
        }
        if (direction == null || direction == Direction.SOUTH) {
            buffer.addVertex(pose, x, 0.0f, z).setColor(r, g, b, a).setNormal(pose, -1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, 0.0f, 0.0f, z).setColor(r, g, b, a).setNormal(pose, -1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, 0.0f, y, z).setColor(r, g, b, a).setNormal(pose, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, x, y, z).setColor(r, g, b, a).setNormal(pose, 1.0f, 0.0f, 0.0f);
        }
        if (direction == null || direction == Direction.WEST) {
            buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, 0.0f, 0.0f, 1.0f);
            buffer.addVertex(pose, 0.0f, 0.0f, z).setColor(r, g, b, a).setNormal(pose, 0.0f, 0.0f, 1.0f);
            buffer.addVertex(pose, 0.0f, y, z).setColor(r, g, b, a).setNormal(pose, 0.0f, 0.0f, -1.0f);
            buffer.addVertex(pose, 0.0f, y, 0.0f).setColor(r, g, b, a).setNormal(pose, 0.0f, 0.0f, -1.0f);
        }
        if (direction == null || direction == Direction.EAST) {
            buffer.addVertex(pose, x, 0.0f, z).setColor(r, g, b, a).setNormal(pose, 0.0f, 0.0f, -1.0f);
            buffer.addVertex(pose, x, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, 0.0f, 0.0f, -1.0f);
            buffer.addVertex(pose, x, y, 0.0f).setColor(r, g, b, a).setNormal(pose, 0.0f, 0.0f, 1.0f);
            buffer.addVertex(pose, x, y, z).setColor(r, g, b, a).setNormal(pose, 0.0f, 0.0f, 1.0f);
        }
        if (direction == Direction.DOWN) {
            buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, x, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, x, 0.0f, z).setColor(r, g, b, a).setNormal(pose, -1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, 0.0f, 0.0f, z).setColor(r, g, b, a).setNormal(pose, -1.0f, 0.0f, 0.0f);
        }
        if (direction == Direction.UP) {
            buffer.addVertex(pose, 0.0f, y, 0.0f).setColor(r, g, b, a).setNormal(pose, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, x, y, 0.0f).setColor(r, g, b, a).setNormal(pose, 1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, x, y, z).setColor(r, g, b, a).setNormal(pose, -1.0f, 0.0f, 0.0f);
            buffer.addVertex(pose, 0.0f, y, z).setColor(r, g, b, a).setNormal(pose, -1.0f, 0.0f, 0.0f);
        }
        if (direction == null) {
            buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, 0.0f, 1.0f, 0.0f);
            buffer.addVertex(pose, 0.0f, y, 0.0f).setColor(r, g, b, a).setNormal(pose, 0.0f, 1.0f, 0.0f);
            buffer.addVertex(pose, x, y, 0.0f).setColor(r, g, b, a).setNormal(pose, 0.0f, -1.0f, 0.0f);
            buffer.addVertex(pose, x, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, 0.0f, -1.0f, 0.0f);
            buffer.addVertex(pose, x, 0.0f, z).setColor(r, g, b, a).setNormal(pose, 0.0f, 1.0f, 0.0f);
            buffer.addVertex(pose, x, y, z).setColor(r, g, b, a).setNormal(pose, 0.0f, 1.0f, 0.0f);
            buffer.addVertex(pose, 0.0f, y, z).setColor(r, g, b, a).setNormal(pose, 0.0f, -1.0f, 0.0f);
            buffer.addVertex(pose, 0.0f, 0.0f, z).setColor(r, g, b, a).setNormal(pose, 0.0f, -1.0f, 0.0f);
        }
    }

    public void addBeamVertices(PoseStack poseStack, VertexConsumer buffer, Vec3 delta, float r, float g, float b, float a) {
        Vec3 normalVec = delta.normalize();
        PoseStack.Pose pose = poseStack.last();
        float x = (float)delta.x;
        float y = (float)delta.y;
        float z = (float)delta.z;
        float xn = (float)normalVec.x;
        float yn = (float)normalVec.y;
        float zn = (float)normalVec.z;
        buffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(r, g, b, a).setNormal(pose, xn, yn, zn);
        buffer.addVertex(pose, x, y, z).setColor(r, g, b, a).setNormal(pose, xn, yn, zn);
    }

    public static class RenderTypeHelper
    extends RenderType {
        public static final RenderType MARKER_LINE_4 = RenderTypeHelper.create((String)"packagedauto:marker_line_4", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)128, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(4.0))).setLayeringState(VIEW_OFFSET_Z_LAYERING).setWriteMaskState(COLOR_WRITE).setDepthTestState(NO_DEPTH_TEST).setCullState(NO_CULL).createCompositeState(false));
        public static final RenderType MARKER_QUAD = RenderTypeHelper.create((String)"packagedauto:marker_quad", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)128, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_SHADER).setLayeringState(VIEW_OFFSET_Z_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setWriteMaskState(COLOR_WRITE).setDepthTestState(NO_DEPTH_TEST).setCullState(NO_CULL).createCompositeState(false));
        public static final RenderType BEAM_LINE_3 = RenderTypeHelper.create((String)"packagedauto:beam_line_3", (VertexFormat)DefaultVertexFormat.POSITION_COLOR_NORMAL, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)8192, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_LINES_SHADER).setLineState(new RenderStateShard.LineStateShard(OptionalDouble.of(3.0))).setLayeringState(VIEW_OFFSET_Z_LAYERING).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(ITEM_ENTITY_TARGET).setWriteMaskState(COLOR_DEPTH_WRITE).setCullState(NO_CULL).createCompositeState(false));

        private RenderTypeHelper(String name, VertexFormat format, VertexFormat.Mode mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
            super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
        }
    }

    public record BeamInfo(Vec3 source, Vec3 delta, int startTick) {
        public BeamInfo(Vec3 source, Vec3 delta) {
            this(source, delta, RenderTimer.INSTANCE.getTicks());
        }

        public boolean shouldRemove(int currentTick) {
            if (currentTick < this.startTick) {
                currentTick += 0x1FFFFF;
            }
            return currentTick - this.startTick >= 6;
        }

        public float getAlpha(float renderTick) {
            float diff = renderTick - (float)this.startTick;
            if (diff < 0.0f) {
                diff += 2097151.0f;
            }
            float factor = diff / 6.0f;
            return 1.0f - factor * factor;
        }
    }
}

